/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.config;

import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.logging.Logging;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class GeneralPropertiesReader {
    public static final Logger LOGGER = Logging.getTheLogger();
    private static final int APPLICATION_RETRYCOUNT_DEFAULT = 3;
    private static final int APPLICATION_POLLINGINTERVAL_DEFAULT = 10;
    private static final boolean APPLICATION_RENEWSESSION_DEFAULT = false;
    private static final boolean APPLICATION_ARCPOLLING_DEFAULT = false;
    private static final int APPLICATION_RENEWSESSIONINTERVAL_DEFAULT = 30;
    private static final boolean MAPSERVER_BASICAUTHENABLED_DEFAULT = true;
    private static final boolean APPLICATION_MESSAGING_SENDOLD = false;
    private static Properties sProps;
    private static boolean sFlag;
    private static String sPath;

    static {
        sFlag = false;
        sPath = "config/config.properties";
    }

    public static void setPath(String path) {
        sPath = path;
    }

    public static void loadProperties(String path) {
        sProps = new Properties();
        try {
            FileInputStream in = new FileInputStream(path);
            sProps.load(in);
            in.close();
            GeneralPropertiesReader.initConfig(sProps);
            sFlag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IfMapClient.exit("error while loading general properties from " + path + "...please check your configuration");
        }
    }

    private static void initConfig(Properties conf) {
        if (!(GeneralPropertiesReader.initConfigFiles(conf) && GeneralPropertiesReader.initApplicationConfig(conf) && GeneralPropertiesReader.initMapServerConfig(conf))) {
            IfMapClient.exit("error while initializing configuration");
        }
    }

    private static boolean initConfigFiles(Properties conf) {
        if (IfMapClient.sInputConfigParams != null && GeneralPropertiesReader.buildConfigFileOptionsFromCommandLineParameters()) {
            return true;
        }
        GeneralConfig.APPLICATION_POLLINGCONFIG_PATH = Toolbox.getStringProperty("application.pollingconfig.path", conf, true);
        if (GeneralConfig.APPLICATION_POLLINGCONFIG_PATH == null) {
            return false;
        }
        GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH = Toolbox.getStringProperty("application.mappingconfig.path", conf, true);
        if (GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH == null) {
            return false;
        }
        GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME = Toolbox.getStringProperty("application.pollingconfig.classname", conf, false);
        if (GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME == null) {
            return false;
        }
        GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME = Toolbox.getStringProperty("application.mappingconfig.classname", conf, false);
        return GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME != null;
    }

    private static boolean buildConfigFileOptionsFromCommandLineParameters() {
        IfMapClient.LOGGER.info("Detected Command Line Configuration Parameter: ");
        int i = 0;
        while (i < IfMapClient.sInputConfigParams.length) {
            IfMapClient.LOGGER.info("Entry[" + i + "]:" + IfMapClient.sInputConfigParams[i].toString());
            ++i;
        }
        boolean isFirstInputParamValid = false;
        if (IfMapClient.sInputConfigParams[0].equals("snort-ascii")) {
            GeneralConfig.APPLICATION_POLLINGCONFIG_PATH = "config/snort/file_polling.properties";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH = "config/snort/mapping.properties";
            GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.pollingthreads.SnortFilePollingThread";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.mappingfactory.SnortFileEventMappingFactory";
            IfMapClient.LOGGER.info("Configured snort-ascii");
            isFirstInputParamValid = true;
        } else if (IfMapClient.sInputConfigParams[0].equals("snort-barnyard")) {
            GeneralConfig.APPLICATION_POLLINGCONFIG_PATH = "config/snort/file_polling.properties";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH = "config/snort/mapping.properties";
            GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.pollingthreads.SnortBarnyardFilePollingThread";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.mappingfactory.SnortBarnyardFileEventMappingFactory";
            IfMapClient.LOGGER.info("Configured snort-barnyard");
            isFirstInputParamValid = true;
        } else if (IfMapClient.sInputConfigParams[0].equals("snort-sql")) {
            GeneralConfig.APPLICATION_POLLINGCONFIG_PATH = "config/snort/db_polling.properties";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH = "config/snort/mapping.properties";
            GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.pollingthreads.SnortSqlPollingThread";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.mappingfactory.SnortSqlEventMappingFactory";
            IfMapClient.LOGGER.info("Configured snort-sql");
            isFirstInputParamValid = true;
        } else if (IfMapClient.sInputConfigParams[0].equals("nagios")) {
            GeneralConfig.APPLICATION_POLLINGCONFIG_PATH = "config/nagios/socket_polling.properties";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH = "config/nagios/mapping.properties";
            GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.pollingthreads.NagiosSocketPollingThread";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.mappingfactory.NagiosEventMappingFactory";
            IfMapClient.LOGGER.info("Configured nagios");
            isFirstInputParamValid = true;
        } else if (IfMapClient.sInputConfigParams[0].equals("iptables")) {
            GeneralConfig.APPLICATION_POLLINGCONFIG_PATH = "config/iptables/file_polling.properties";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH = "config/iptables/mapping.properties";
            GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.pollingthreads.IPTablesULogFilePollingThread";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.mappingfactory.IPTablesEventMappingFactory";
            IfMapClient.LOGGER.info("Configured iptables");
            isFirstInputParamValid = true;
        } else if (IfMapClient.sInputConfigParams[0].equals("radius-file")) {
            GeneralConfig.APPLICATION_POLLINGCONFIG_PATH = "config/radius/file_polling.properties";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH = "config/radius/mapping.properties";
            GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.pollingthreads.RadiusFilePollingThread";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.mappingfactory.RadiusEventMappingFactory";
            IfMapClient.LOGGER.info("Configured radius-file");
            isFirstInputParamValid = true;
        } else if (IfMapClient.sInputConfigParams[0].equals("radius-sql")) {
            GeneralConfig.APPLICATION_POLLINGCONFIG_PATH = "config/radius/sql_polling.properties";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH = "config/radius/mapping.properties";
            GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.pollingthreads.RadiusSqlPollingThread";
            GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME = "de.esukom.decoit.ifmapclient.mappingfactory.RadiusSQLEventMappingFactory";
            IfMapClient.LOGGER.info("Configured radius-sql");
            isFirstInputParamValid = true;
        }
        if (IfMapClient.sInputConfigParams.length > 1 && isFirstInputParamValid) {
            if (IfMapClient.sInputConfigParams[1].equals("esukom-mode")) {
                GeneralConfig.APPLICATION_IPTABLES_MODE = "esukom";
                GeneralConfig.APPLICATION_SNORT_MODE = "esukom";
                IfMapClient.LOGGER.info("Configured esukom-mode");
            } else if (IfMapClient.sInputConfigParams[1].equals("default-mode")) {
                GeneralConfig.APPLICATION_IPTABLES_MODE = "default";
                GeneralConfig.APPLICATION_SNORT_MODE = "default";
                IfMapClient.LOGGER.info("Configured default-mode");
            } else {
                GeneralConfig.APPLICATION_IPTABLES_MODE = "default";
                GeneralConfig.APPLICATION_SNORT_MODE = "default";
                IfMapClient.LOGGER.info("unknown second input parameter...configured default-mode");
            }
            return true;
        }
        if (IfMapClient.sInputConfigParams.length == 1 && isFirstInputParamValid) {
            GeneralConfig.APPLICATION_IPTABLES_MODE = "default";
            GeneralConfig.APPLICATION_SNORT_MODE = "default";
            IfMapClient.LOGGER.info("Configured default-mode");
            return true;
        }
        IfMapClient.LOGGER.warning("Command Line Configuration Parameter not valid...using config-file values instead!");
        return false;
    }

    private static boolean initApplicationConfig(Properties conf) {
        GeneralConfig.APPLICATION_VERSION_STRING = Toolbox.getStringProperty("application.version", conf, false);
        GeneralConfig.APPLICATION_CONNECTION_RETRYCOUNT = Toolbox.getIntPropertyWithDefault("application.connection.retrycount", 3, conf, true);
        GeneralConfig.APPLICATION_POLLING_INTERVAL = Toolbox.getIntPropertyWithDefault("application.polling.interval", 10, conf, true);
        GeneralConfig.APPLICATION_RENEWSESSION_ENABLED = Toolbox.getBoolPropertyWithDefault("application.renewsession.enabled", false, conf);
        GeneralConfig.APPLICATION_ARCPOLLING_ENABLED = IfMapClient.sInputConfigParams != null && IfMapClient.sInputConfigParams.equals("iptables") ? true : Toolbox.getBoolPropertyWithDefault("application.arcpolling.enabled", false, conf);
        GeneralConfig.APPLICATION_MESSAGING_SENDOLD = Toolbox.getBoolPropertyWithDefault("application.messaging.sendold", false, conf);
        GeneralConfig.APPLICATION_RENEWSESSION_INTERVALL = Toolbox.getIntPropertyWithDefault("application.renewsession.intervall", 30, conf, true);
        GeneralConfig.APPLICATION_IPADDRESS = Toolbox.getStringPropertyWithDefault("application.ipaddress", conf, "unknown");
        GeneralConfig.APPLICATION_SNORT_MODE = Toolbox.getStringPropertyWithDefault("application.snort.mode", conf, "default");
        GeneralConfig.APPLICATION_IPTABLES_MODE = Toolbox.getStringPropertyWithDefault("application.iptables.mode", conf, "default");
        GeneralConfig.APPLICATION_IPTABLES_STARTSCRIPT = Toolbox.getStringPropertyWithDefault("application.iptables.startscript", conf, "config/iptables/intialize_rules.sh");
        GeneralConfig.APPLICATION_IPTABLES_SENDDATASTREAMDETECTEDEVENT = Toolbox.getBoolPropertyWithDefault("application.iptables.senddatastreamevents", false, conf);
        GeneralConfig.APPLICATION_IPTABLES_GATEWAYMODE = Toolbox.getBoolPropertyWithDefault("application.iptables.gateway", false, conf);
        GeneralConfig.APPLICATION_MESSAGING_TYPE = Toolbox.getStringProperty("application.messaging.type", conf, false);
        if (GeneralConfig.APPLICATION_MESSAGING_TYPE == null || !GeneralConfig.APPLICATION_MESSAGING_TYPE.equalsIgnoreCase("update") && !GeneralConfig.APPLICATION_MESSAGING_TYPE.equalsIgnoreCase("notify")) {
            return false;
        }
        SOAPMessageSender.publishMode = GeneralConfig.APPLICATION_MESSAGING_TYPE.equalsIgnoreCase("update") ? (byte)0 : 1;
        return true;
    }

    private static boolean initMapServerConfig(Properties conf) {
        GeneralConfig.MAPSERVER_URL = Toolbox.getStringProperty("mapserver.url", conf, false);
        if (GeneralConfig.MAPSERVER_URL == null) {
            return false;
        }
        if (IfMapClient.sInputConfigParams == null || !GeneralPropertiesReader.buildSSLConfigFromCommandLineParamaeter()) {
            GeneralConfig.MAPSERVER_KEYSTORE_PATH = Toolbox.getStringProperty("mapserver.keystore.path", conf, true);
            if (GeneralConfig.MAPSERVER_KEYSTORE_PATH == null) {
                return false;
            }
            GeneralConfig.MAPSERVER_KEYSTORE_PASSWORD = Toolbox.getStringProperty("mapserver.keystore.password", conf, false);
            if (GeneralConfig.MAPSERVER_KEYSTORE_PASSWORD == null) {
                return false;
            }
            GeneralConfig.MAPSERVER_TRUSTSTORE_PATH = Toolbox.getStringProperty("mapserver.truststore.path", conf, true);
            if (GeneralConfig.MAPSERVER_TRUSTSTORE_PATH == null) {
                return false;
            }
            GeneralConfig.MAPSERVER_TRUSTSTORE_PASSWORD = Toolbox.getStringProperty("mapserver.truststore.password", conf, false);
            if (GeneralConfig.MAPSERVER_TRUSTSTORE_PASSWORD == null) {
                return false;
            }
        }
        GeneralConfig.MAPSERVER_BASICAUTH_ENABLED = Toolbox.getBoolPropertyWithDefault("mapserver.basicauth.enabled", true, conf);
        GeneralConfig.MAPSERVER_BASICAUTH_USER = Toolbox.getStringProperty("mapserver.basicauth.user", conf, false);
        if (GeneralConfig.MAPSERVER_BASICAUTH_USER == null) {
            return false;
        }
        GeneralConfig.MAPSERVER_BASICAUTH_PASSWORD = Toolbox.getStringProperty("mapserver.basicauth.password", conf, false);
        return GeneralConfig.MAPSERVER_BASICAUTH_PASSWORD != null;
    }

    private static boolean buildSSLConfigFromCommandLineParamaeter() {
        IfMapClient.LOGGER.info("Detected Command Line Configuration Parameter: " + IfMapClient.sInputConfigParams);
        if (IfMapClient.sInputConfigParams[0].equals("snort-ascii") || IfMapClient.sInputConfigParams[0].equals("snort-barnyard") || IfMapClient.sInputConfigParams[0].equals("snort-sql")) {
            GeneralConfig.MAPSERVER_KEYSTORE_PATH = "keystore/snortmap.jks";
            GeneralConfig.MAPSERVER_KEYSTORE_PASSWORD = "snortmap";
            GeneralConfig.MAPSERVER_TRUSTSTORE_PATH = "keystore/snortmap.jks";
            GeneralConfig.MAPSERVER_TRUSTSTORE_PASSWORD = "snortmap";
            IfMapClient.LOGGER.info("using snortmap as key and trusstore with password snortmap");
            return true;
        }
        if (IfMapClient.sInputConfigParams[0].equals("nagios")) {
            GeneralConfig.MAPSERVER_KEYSTORE_PATH = "keystore/nagiosmap.jks";
            GeneralConfig.MAPSERVER_KEYSTORE_PASSWORD = "nagiosmap";
            GeneralConfig.MAPSERVER_TRUSTSTORE_PATH = "keystore/nagiosmap.jks";
            GeneralConfig.MAPSERVER_TRUSTSTORE_PASSWORD = "nagiosmap";
            IfMapClient.LOGGER.info("using nagiosmap as key and trusstore with password nagiosmap");
            return true;
        }
        if (IfMapClient.sInputConfigParams[0].equals("iptables")) {
            GeneralConfig.MAPSERVER_KEYSTORE_PATH = "keystore/iptablesmap.jks";
            GeneralConfig.MAPSERVER_KEYSTORE_PASSWORD = "iptablesmap";
            GeneralConfig.MAPSERVER_TRUSTSTORE_PATH = "keystore/iptablesmap.jks";
            GeneralConfig.MAPSERVER_TRUSTSTORE_PASSWORD = "iptablesmap";
            IfMapClient.LOGGER.info("Cusing iptables as key and trusstore with password iptablesmap");
            return true;
        }
        if (IfMapClient.sInputConfigParams[0].equals("radius-sql")) {
            GeneralConfig.MAPSERVER_KEYSTORE_PATH = "keystore/freeradius.jks";
            GeneralConfig.MAPSERVER_KEYSTORE_PASSWORD = "freeradius";
            GeneralConfig.MAPSERVER_TRUSTSTORE_PATH = "keystore/freeradius.jks";
            GeneralConfig.MAPSERVER_TRUSTSTORE_PASSWORD = "freeradius";
            IfMapClient.LOGGER.info("using radius as key and trusstore with password freeradius");
            return true;
        }
        IfMapClient.LOGGER.warning("Command Line Configuration Parameter not valid...using config-file values instead!");
        return false;
    }

    public static String getProperty(String ident) {
        if (!sFlag) {
            GeneralPropertiesReader.loadProperties(sPath);
        }
        String value = sProps.getProperty(ident);
        return value;
    }
}

