/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.iptables;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.iptables.PollResultChecker;
import de.esukom.decoit.ifmapclient.iptables.RulesExecutor;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.messaging.IFMAPMessagingFacade;
import de.esukom.decoit.ifmapclient.messaging.PollingClientListEntry;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import de.fhhannover.inform.trust.ifmapj.identifier.IpAddress;
import de.fhhannover.inform.trust.ifmapj.messages.ResultItem;
import de.fhhannover.inform.trust.ifmapj.metadata.EnforcementAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class IPTablesFacade {
    private static IPTablesFacade sInstance = new IPTablesFacade();
    public boolean mSkipAllowClientCheck = false;
    private PollResultChecker mResultChecker;
    private Multimap<String, String> mEnforcementMappingContains = HashMultimap.create();
    private Multimap<String, String> mEnforcementMappingMatches = HashMultimap.create();
    private Multimap<String, Integer> mEnforcementMappingEquals = HashMultimap.create();
    private Multimap<String, Integer> mEnforcementMappingLower = HashMultimap.create();
    private Multimap<String, Integer> mEnforcementMappingGreater = HashMultimap.create();
    private Multimap<String, String> mAllowMappingContains = HashMultimap.create();
    private Multimap<String, String> mAllowMappingMatches = HashMultimap.create();
    private Multimap<String, Integer> mAllowMappingEquals = HashMultimap.create();
    private Multimap<String, Integer> mAllowMappingLower = HashMultimap.create();
    private Multimap<String, Integer> mAllowMappingGreater = HashMultimap.create();

    private IPTablesFacade() {
        this.mResultChecker = new PollResultChecker();
    }

    public static synchronized IPTablesFacade getInstance() {
        return sInstance;
    }

    public void init(Properties pr) {
        this.initializeProperties(pr, "iptables.allow.mapping", this.mAllowMappingContains, this.mAllowMappingMatches, this.mAllowMappingEquals, this.mAllowMappingGreater, this.mAllowMappingLower, "(role_name|capability_name|device-characteristic_os-version|device-characteristic_os|device-characteristic_model|device-characteristic_manufacturer|device-characteristic_device-type|access-request-ip_ncp-ip-address-type)");
        this.initializeProperties(pr, "iptables.enforcement.mapping", this.mEnforcementMappingContains, this.mEnforcementMappingMatches, this.mEnforcementMappingEquals, this.mEnforcementMappingGreater, this.mEnforcementMappingLower, "(ip|name|significance|confidence|magnitude|message)");
        this.ouputRulesLists();
    }

    private void initializeProperties(Properties pr, String targetProperty, Multimap<String, String> containsMap, Multimap<String, String> matchesMap, Multimap<String, Integer> equalsMap, Multimap<String, Integer> greaterMap, Multimap<String, Integer> lowerMap, String attributesRegEx) {
        int i;
        if (targetProperty.equals("iptables.allow.mapping")) {
            String[] values = pr.getProperty("iptables.allow.mapping").split(",");
            i = 0;
            while (i < values.length) {
                if (values[i].equals("skip") || values[i].equals("SKIP")) {
                    this.mSkipAllowClientCheck = true;
                    IfMapClient.LOGGER.config("ip-tables client allow-check has been set to skip...disabling allow-check");
                    return;
                }
                ++i;
            }
        }
        String[] propertiesStrings = null;
        propertiesStrings = pr.getProperty(targetProperty).split(",");
        if (!Toolbox.checkConfig(propertiesStrings)) {
            matchesMap = null;
            containsMap = null;
            equalsMap = null;
            greaterMap = null;
            lowerMap = null;
            IfMapClient.LOGGER.config("could not find any properties for ip-tables-rules...not initializing any rules");
        } else {
            i = 0;
            while (i < propertiesStrings.length) {
                if (targetProperty.equals("iptables.allow.mapping")) {
                    this.initializeAllowanceRules(attributesRegEx, propertiesStrings[i], containsMap, matchesMap);
                } else {
                    this.initializeEnforcementRules(attributesRegEx, propertiesStrings[i], equalsMap, greaterMap, lowerMap, containsMap, matchesMap);
                }
                ++i;
            }
        }
    }

    private void initializeEnforcementRules(String attributesRegEx, String propertiesString, Multimap<String, Integer> equalsMap, Multimap<String, Integer> greaterMap, Multimap<String, Integer> lowerMap, Multimap<String, String> containsMap, Multimap<String, String> matchesMap) {
        String targetAttributeString = null;
        Matcher targetAttributeMatcher = Toolbox.getRegExPattern(attributesRegEx).matcher(propertiesString);
        if (!targetAttributeMatcher.find()) {
            IfMapClient.LOGGER.config("could not find target-attribute for rule: " + propertiesString + "...skipping rule");
            return;
        }
        targetAttributeString = targetAttributeMatcher.group();
        String filterString = null;
        Matcher filterStringMatcher = Toolbox.getRegExPattern("\\[.*\\]").matcher(propertiesString);
        if (!filterStringMatcher.find()) {
            IfMapClient.LOGGER.config("could not find filter for rule: " + propertiesString + "...skipping rule");
            return;
        }
        filterString = filterStringMatcher.group().replace("[", "").replace("]", "");
        if (filterString != null & filterString.length() > 0 & (targetAttributeString != null & targetAttributeString.length() > 0)) {
            if (targetAttributeString.equalsIgnoreCase("confidence") || targetAttributeString.equalsIgnoreCase("magnitude")) {
                int filterValue;
                try {
                    filterValue = new Integer(filterString);
                }
                catch (ClassCastException e) {
                    IfMapClient.LOGGER.config("could not cast filter-String " + filterString + " to integer value...skipping rule");
                    return;
                }
                if (propertiesString.startsWith(String.valueOf(targetAttributeString) + "_e") | propertiesString.startsWith(String.valueOf(targetAttributeString) + "_E")) {
                    equalsMap.put((Object)targetAttributeString, (Object)filterValue);
                    IfMapClient.LOGGER.config("setting new rule: " + targetAttributeString + " EQUALS " + filterValue);
                } else if (propertiesString.startsWith(String.valueOf(targetAttributeString) + "_g") | propertiesString.startsWith(String.valueOf(targetAttributeString) + "_G")) {
                    greaterMap.put((Object)targetAttributeString, (Object)filterValue);
                    IfMapClient.LOGGER.config("setting new rule: " + targetAttributeString + " GREATER " + filterValue);
                } else if (propertiesString.startsWith(String.valueOf(targetAttributeString) + "_l") | propertiesString.startsWith(String.valueOf(targetAttributeString) + "_L")) {
                    lowerMap.put((Object)targetAttributeString, (Object)filterValue);
                    IfMapClient.LOGGER.config("setting new rule: " + targetAttributeString + " LESS " + filterValue);
                }
            } else if (targetAttributeString.equalsIgnoreCase("significance") || targetAttributeString.equals("type") || targetAttributeString.equals("name") || targetAttributeString.equals("discovererId") || targetAttributeString.equals("ip") || targetAttributeString.equals("message")) {
                if (propertiesString.startsWith(String.valueOf(targetAttributeString) + "_c") | propertiesString.startsWith(String.valueOf(targetAttributeString) + "_C")) {
                    containsMap.put((Object)targetAttributeString, (Object)filterString);
                    IfMapClient.LOGGER.config("setting new rule: " + targetAttributeString + " CONTAINS " + filterString);
                } else if (propertiesString.startsWith(String.valueOf(targetAttributeString) + "_m") | propertiesString.startsWith(String.valueOf(targetAttributeString) + "_M")) {
                    matchesMap.put((Object)targetAttributeString, (Object)filterString);
                    IfMapClient.LOGGER.config("setting new rule: " + targetAttributeString + " MATCHES " + filterString);
                }
            } else {
                IfMapClient.LOGGER.config("could not detectect filter-option for entry: " + targetAttributeString + " MATCHES/CONTAINS " + filterString + "...skipping entry");
            }
        } else {
            IfMapClient.LOGGER.config("could not detectect filter-string for entry: " + targetAttributeString + " OPERATION " + filterString + "...skipping entry");
        }
    }

    private void initializeAllowanceRules(String attributesRegEx, String propertiesString, Multimap<String, String> containsMap, Multimap<String, String> matchesMap) {
        String targetAttributeString = null;
        Matcher targetAttributeMatcher = Toolbox.getRegExPattern(attributesRegEx).matcher(propertiesString);
        if (!targetAttributeMatcher.find()) {
            IfMapClient.LOGGER.config("could not find target-attribute for rule: " + propertiesString + "...skipping rule");
            return;
        }
        targetAttributeString = targetAttributeMatcher.group();
        String filterString = null;
        Matcher filterStringMatcher = Toolbox.getRegExPattern("\\[.*\\]").matcher(propertiesString);
        if (!filterStringMatcher.find()) {
            IfMapClient.LOGGER.config("could not find filter for rule: " + propertiesString + "...skipping rule");
            return;
        }
        filterString = filterStringMatcher.group().replace("[", "").replace("]", "");
        if (filterString != null & filterString.length() > 0 & (targetAttributeString != null & targetAttributeString.length() > 0)) {
            if (propertiesString.startsWith(String.valueOf(targetAttributeString) + "_c") | propertiesString.startsWith(String.valueOf(targetAttributeString) + "_C")) {
                containsMap.put((Object)targetAttributeString, (Object)filterString);
                IfMapClient.LOGGER.config("setting new rule: " + targetAttributeString + " CONTAINS " + filterString);
            } else if (propertiesString.startsWith(String.valueOf(targetAttributeString) + "_m") | propertiesString.startsWith(String.valueOf(targetAttributeString) + "_M")) {
                matchesMap.put((Object)targetAttributeString, (Object)filterString);
                IfMapClient.LOGGER.config("setting new rule: " + targetAttributeString + " MATCHES " + filterString);
            } else if (propertiesString.startsWith(String.valueOf(targetAttributeString) + "_!c") | propertiesString.startsWith(String.valueOf(targetAttributeString) + "_!C")) {
                containsMap.put((Object)("!" + targetAttributeString), (Object)filterString);
                IfMapClient.LOGGER.config("setting new rule: " + targetAttributeString + " NOT CONTAINS " + filterString);
            } else if (propertiesString.startsWith(String.valueOf(targetAttributeString) + "_!m") | propertiesString.startsWith(String.valueOf(targetAttributeString) + "_!M")) {
                matchesMap.put((Object)("!" + targetAttributeString), (Object)filterString);
                IfMapClient.LOGGER.config("setting new rule: " + targetAttributeString + " NOT MATCHES " + filterString);
            } else {
                IfMapClient.LOGGER.config("could not detectect filter-option for entry: " + targetAttributeString + " MATCHES/CONTAINS " + filterString + "...skipping entry");
            }
        } else {
            IfMapClient.LOGGER.config("could not detectect filter-string for entry: " + targetAttributeString + " MATCHES/CONTAINS " + filterString + "...skipping entry");
        }
    }

    public void checkPollResultForIPTablesEvent(Collection<ResultItem> ris, byte pollResultType) {
        IfMapClient.LOGGER.info("checking poll-result for ip-tables-related metadata...");
        if (pollResultType == 5 & this.mSkipAllowClientCheck) {
            IfMapClient.LOGGER.info("skipping of allowance-check has been activated...unblocking all clients that are new!");
            this.allowClientsFromClientList();
        }
        String ip = null;
        for (ResultItem ri : ris) {
            if (ri.getIdentifier1().toString().contains("ip")) {
                IpAddress ipIdentifier = (IpAddress)ri.getIdentifier1();
                ip = ipIdentifier.getValue();
            }
            List mresult = ri.getMetadata();
            for (Document currentMetaDoc : mresult) {
                NodeList list = currentMetaDoc.getChildNodes();
                if (list == null || list.getLength() <= 0) continue;
                if (pollResultType == 6) {
                    String reason = this.checkPollUpdateMetadataForEnforcement(list, pollResultType);
                    if (reason == null || ip == null || ip.length() <= 0) continue;
                    this.enforceClient(ip, reason);
                    continue;
                }
                if (pollResultType == 5) {
                    if (!this.checkPollSearchMetadataForAllowance(list, pollResultType) || ip == null || ip.length() <= 0) continue;
                    this.allowClient(ip);
                    continue;
                }
                IfMapClient.LOGGER.warning("unknown poll-result type...skipping result-check!");
            }
        }
    }

    private HashMap<String, String> collectEnforcementDataFromPollResult(Collection<Document> pollResult) {
        String source = null;
        String message = null;
        boolean isAlertSource = false;
        boolean isAlertMessage = false;
        for (Document currentMetaDoc : pollResult) {
            NodeList list = currentMetaDoc.getChildNodes();
            if (list == null || list.getLength() <= 0) continue;
            int j = 0;
            while (j < list.getLength()) {
                if (list.item(j).getLocalName().equals("feature")) {
                    NodeList child = list.item(j).getChildNodes();
                    int k = 0;
                    while (k < child.getLength()) {
                        if (child.item(k).getNodeName() != null && child.item(k).getTextContent() != null) {
                            if (child.item(k).getNodeName().equals("id") && child.item(k).getTextContent().equalsIgnoreCase("Alert.Source")) {
                                isAlertSource = true;
                            } else if (child.item(k).getNodeName().equals("id") && child.item(k).getTextContent().equalsIgnoreCase("Alert.Message")) {
                                isAlertMessage = true;
                            }
                            if (child.item(k).getNodeName().equals("value")) {
                                if (isAlertSource) {
                                    source = child.item(k).getTextContent();
                                    isAlertSource = false;
                                }
                                if (isAlertMessage) {
                                    message = child.item(k).getTextContent();
                                    isAlertMessage = false;
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        if (source != null && message != null) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("source", source);
            returnMap.put("message", message);
            return returnMap;
        }
        return null;
    }

    public void checkPollResultForIPTablesAlert(Collection<ResultItem> ris, byte pollResultType) {
        IfMapClient.LOGGER.info("checking poll-result for ip-tables-related metadata...");
        ArrayList<HashMap<String, String>> res = new ArrayList<HashMap<String, String>>();
        for (ResultItem ri : ris) {
            HashMap<String, String> collectedData;
            List mresult = ri.getMetadata();
            if (pollResultType != 6 || (collectedData = this.collectEnforcementDataFromPollResult(mresult)) == null) continue;
            res.add(collectedData);
        }
        this.checkAndExecuteEnforcementByAlertEvent(res);
    }

    private void checkAndExecuteEnforcementByAlertEvent(ArrayList<HashMap<String, String>> pollResultData) {
        IfMapClient.LOGGER.info("checkAndExecuteEnforcementByAlertEvent called...");
        int i = 0;
        while (i < pollResultData.size()) {
            String currentMessage = pollResultData.get(i).get("message");
            IfMapClient.LOGGER.info("current message: " + currentMessage);
            if (this.mResultChecker.checkPollResultForIPTablesStringRules(this.mEnforcementMappingMatches, "message", currentMessage, (byte)1, (byte)6)) {
                IfMapClient.LOGGER.info("Der eine hier");
                this.enforceClient(pollResultData.get(i).get("source"), currentMessage);
            }
            if (this.mResultChecker.checkPollResultForIPTablesStringRules(this.mEnforcementMappingContains, "message", currentMessage, (byte)0, (byte)6)) {
                IfMapClient.LOGGER.info("Der andere Dort");
                this.enforceClient(pollResultData.get(i).get("source"), currentMessage);
            }
            ++i;
        }
    }

    private String checkPollUpdateMetadataForEnforcement(NodeList list, byte resultType) {
        IfMapClient.LOGGER.info("checking poll-update result for enforcement...");
        int j = 0;
        while (j < list.getLength()) {
            if (list.item(j).getLocalName().equals("event")) {
                NodeList child = list.item(j).getChildNodes();
                int k = 0;
                while (k < child.getLength()) {
                    if (child.item(k).getNodeName() != null && child.item(k).getTextContent() != null) {
                        if (child.item(k).getNodeName().equals("name") || child.item(k).getNodeName().equals("significance") || child.item(k).getNodeName().equals("type") || child.item(k).getNodeName().equals("discovered-time") || child.item(k).getNodeName().equals("discoverer-id") || child.item(k).getNodeName().equals("other-type-definition") || child.item(k).getNodeName().equals("information")) {
                            if (this.mResultChecker.checkPollResultForIPTablesStringRules(this.mEnforcementMappingContains, child.item(k).getNodeName(), child.item(k).getTextContent(), (byte)0, resultType)) {
                                return "ENFORCEMENT REASON: " + child.item(k).getTextContent() + " detected";
                            }
                            if (this.mResultChecker.checkPollResultForIPTablesStringRules(this.mEnforcementMappingMatches, child.item(k).getNodeName(), child.item(k).getTextContent(), (byte)1, resultType)) {
                                return "ENFORCEMENT REASON: " + child.item(k).getTextContent() + " detected";
                            }
                        } else if (child.item(k).getNodeName().equals("magnitude") || child.item(k).getNodeName().equals("confidence")) {
                            if (this.mResultChecker.checkPollResultForIPTablesIntegerRules(this.mEnforcementMappingEquals, child.item(k).getNodeName(), new Integer(child.item(k).getTextContent()), (byte)2, resultType)) {
                                return "ENFORCEMENT REASON: " + child.item(k).getTextContent() + " detected";
                            }
                            if (this.mResultChecker.checkPollResultForIPTablesIntegerRules(this.mEnforcementMappingGreater, child.item(k).getNodeName(), new Integer(child.item(k).getTextContent()), (byte)3, resultType)) {
                                return "ENFORCEMENT REASON: " + child.item(k).getTextContent() + " detected";
                            }
                            if (this.mResultChecker.checkPollResultForIPTablesIntegerRules(this.mEnforcementMappingLower, child.item(k).getNodeName(), new Integer(child.item(k).getTextContent()), (byte)4, resultType)) {
                                return "ENFORCEMENT REASON: " + child.item(k).getTextContent() + " detected";
                            }
                        }
                    }
                    ++k;
                }
            }
            ++j;
        }
        return null;
    }

    public boolean checkPollSearchMetadataForAllowance(NodeList list, byte resultType) {
        IfMapClient.LOGGER.fine("checking poll-search result for allowance...");
        int j = 0;
        while (j < list.getLength()) {
            IfMapClient.LOGGER.fine("current local name is: " + list.item(j).getLocalName());
            if (list.item(j).getLocalName().equals("role") || list.item(j).getLocalName().equals("capability") || list.item(j).getLocalName().equals("device-characteristic") || list.item(j).getLocalName().equals("access-request-ip")) {
                NodeList child = list.item(j).getChildNodes();
                int k = 0;
                while (k < child.getLength()) {
                    if (child.item(k).getNodeName() != null && child.item(k).getTextContent() != null) {
                        IfMapClient.LOGGER.fine("entry [" + k + "]: " + child.item(k).getNodeName() + " - " + child.item(k).getTextContent());
                        IfMapClient.LOGGER.fine("----> NOW CHECKING " + child.item(k).getNodeName() + " <----");
                        if (this.mResultChecker.checkPollResultForIPTablesStringRules(this.mAllowMappingContains, child.item(k).getNodeName(), child.item(k).getTextContent(), (byte)0, resultType)) {
                            return true;
                        }
                        if (this.mResultChecker.checkPollResultForIPTablesStringRules(this.mAllowMappingMatches, child.item(k).getNodeName(), child.item(k).getTextContent(), (byte)1, resultType)) {
                            return true;
                        }
                    }
                    ++k;
                }
            }
            ++j;
        }
        return false;
    }

    private void enforceClient(String ip, String reason) {
        if (!ip.equals(IFMAPMessagingFacade.getInstance().mapServerIP)) {
            if (IFMAPMessagingFacade.getInstance().pollingClientList.isClientBlocked(ip)) {
                IfMapClient.LOGGER.info("client with ip " + ip + " is already blocked...no need to block it again!");
            } else {
                IfMapClient.LOGGER.info("client with ip " + ip + " is not blocked...executing ip-tables blocking rule!");
                RulesExecutor ipTablesRulesExecutor = RulesExecutor.getInstance();
                IfMapClient.LOGGER.info("executing block rule for input tables for client " + ip);
                if (!ipTablesRulesExecutor.executePredefinedRule((byte)4, new String[]{ip})) {
                    PollingClientListEntry curEntry = IFMAPMessagingFacade.getInstance().pollingClientList.getEntryByIpString(ip);
                    if (curEntry == null) {
                        IfMapClient.LOGGER.info("client " + ip + "is not in client list...creating new entry");
                        curEntry = new PollingClientListEntry(ip);
                        IFMAPMessagingFacade.getInstance().pollingClientList.insertEntryIfIPNotExists(curEntry);
                    }
                    IfMapClient.LOGGER.info("setting client " + ip + " in client list in block state");
                    IFMAPMessagingFacade.getInstance().pollingClientList.getEntryByIpString(ip).setForceBlocked(true);
                }
                if (GeneralConfig.APPLICATION_IPTABLES_GATEWAYMODE) {
                    IfMapClient.LOGGER.info("executing block rule for forward tables for client " + ip);
                    if (ipTablesRulesExecutor.executePredefinedRule((byte)9, new String[]{ip})) {
                        IFMAPMessagingFacade.getInstance().pollingClientList.getEntryByIpString(ip).setAllowed(false);
                        IFMAPMessagingFacade.getInstance().pollingClientList.getEntryByIpString(ip).setForceBlocked(true);
                        IFMAPMessagingFacade.getInstance().sender.publishEnforcementReportUpdate(ip, EnforcementAction.block, reason, reason);
                    } else {
                        IfMapClient.LOGGER.info("setting client " + ip + " in client list in block state");
                        IFMAPMessagingFacade.getInstance().pollingClientList.getEntryByIpString(ip).setForceBlocked(true);
                    }
                }
            }
        }
    }

    private void allowClient(String ip) {
        IFMAPMessagingFacade.getInstance().pollingClientList.allowClient(ip);
    }

    public void executeIPTableStartRules(String mapServerIp) {
        Process p = null;
        try {
            IfMapClient.LOGGER.config("executing ip-tables-startup-script at: " + GeneralConfig.APPLICATION_IPTABLES_STARTSCRIPT);
            p = Runtime.getRuntime().exec("sh " + GeneralConfig.APPLICATION_IPTABLES_STARTSCRIPT);
            int returnCode = p.waitFor();
            IfMapClient.LOGGER.config("ip-tables-startup-script return-code: " + returnCode);
            if (returnCode != 0) {
                IfMapClient.exit("error while executing iptables-startup-rules-script...please check the file-path in config.properties");
            }
        }
        catch (Exception e) {
            IfMapClient.exit("error while executing iptables-startup-rules-script...please check the file-path in config.properties");
        }
        RulesExecutor.getInstance().executePredefinedRule((byte)2, new String[]{mapServerIp});
    }

    public void allowClientsFromClientList() {
        int i = 0;
        while (i < IFMAPMessagingFacade.getInstance().pollingClientList.getClientList().size()) {
            if (!IFMAPMessagingFacade.getInstance().pollingClientList.getClientList().get(i).getIPAddress().equals(IFMAPMessagingFacade.getInstance().mapServerIP) && IFMAPMessagingFacade.getInstance().pollingClientList.getClientList().get(i).isSubscribed() & !IFMAPMessagingFacade.getInstance().pollingClientList.getClientList().get(i).isAllowed() & !IFMAPMessagingFacade.getInstance().pollingClientList.getClientList().get(i).isForceBlocked()) {
                RulesExecutor ipTablesRulesExecutor = RulesExecutor.getInstance();
                ipTablesRulesExecutor.executePredefinedRule((byte)2, new String[]{IFMAPMessagingFacade.getInstance().pollingClientList.getClientList().get(i).getIPAddress()});
                IFMAPMessagingFacade.getInstance().pollingClientList.getClientList().get(i).setAllowed(true);
                IfMapClient.LOGGER.info("Client with IP " + IFMAPMessagingFacade.getInstance().pollingClientList.getClientList().get(i).getIPAddress() + " has been alowed and unblocked!");
            }
            ++i;
        }
    }

    public void ouputRulesLists() {
        IfMapClient.LOGGER.config("-------------------------------------------------------------------------------------------------------");
        IfMapClient.LOGGER.config("completed initialization of ip-rules-lists ... current initialized rules are:");
        IfMapClient.LOGGER.config("");
        IfMapClient.LOGGER.config("ENFORCMENT_MAPPING_CONTAINS: " + this.mEnforcementMappingContains.toString());
        IfMapClient.LOGGER.config("ENFORCMENT_MAPPING_MATCHES: " + this.mEnforcementMappingMatches.toString());
        IfMapClient.LOGGER.config("ENFORCMENT_MAPPING_EQUALS: " + this.mEnforcementMappingEquals.toString());
        IfMapClient.LOGGER.config("ENFORCMENT_MAPPING_GREATER: " + this.mEnforcementMappingGreater.toString());
        IfMapClient.LOGGER.config("ENFORCMENT_MAPPING_LOWER: " + this.mEnforcementMappingLower.toString());
        IfMapClient.LOGGER.config("");
        IfMapClient.LOGGER.config("ALLOW_MAPPING_CONTAINS: " + this.mAllowMappingContains.toString());
        IfMapClient.LOGGER.config("ALLOW_MAPPING_MATCHES: " + this.mAllowMappingMatches.toString());
        IfMapClient.LOGGER.config("-------------------------------------------------------------------------------------------------------");
    }
}

