/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingFactory;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import de.fhhannover.inform.trust.ifmapj.metadata.Significance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public abstract class SnortEventMappingFactory
extends MappingFactory {
    public HashMap<String, String> eventMap = null;
    public HashMap<String, String> significanceMap = null;
    public boolean logP2P = true;
    public boolean logCVE = true;
    public boolean logBotnetInfection = true;
    public boolean logWormInfection = true;
    public boolean logExcessiveFlows = true;
    public boolean logBehavioralChange = true;
    public boolean logPolicyViolation = true;
    public boolean logOther = true;

    public SnortEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void initProperties(Properties props) {
        String[] wormInfection;
        String[] policyViolation;
        String[] p2p;
        String[] other;
        String[] excessiveFlows;
        String[] cve;
        String[] botnetInfection;
        String[] behavioralChange = props.getProperty("snort.eventmapping.behavioral_change").split(",");
        if (!this.checkConfig(behavioralChange)) {
            behavioralChange = null;
        }
        if (!this.checkConfig(botnetInfection = props.getProperty("snort.eventmapping.botnet_infection").split(","))) {
            botnetInfection = null;
        }
        if (!this.checkConfig(cve = props.getProperty("snort.eventmapping.cve").split(","))) {
            cve = null;
        }
        if (!this.checkConfig(excessiveFlows = props.getProperty("snort.eventmapping.excessive_flows").split(","))) {
            excessiveFlows = null;
        }
        if (!this.checkConfig(other = props.getProperty("snort.eventmapping.other").split(","))) {
            other = null;
        }
        if (!this.checkConfig(p2p = props.getProperty("snort.eventmapping.p2p").split(","))) {
            p2p = null;
        }
        if (!this.checkConfig(policyViolation = props.getProperty("snort.eventmapping.policy_violation").split(","))) {
            policyViolation = null;
        }
        if (!this.checkConfig(wormInfection = props.getProperty("snort.eventmapping.worm_infection").split(","))) {
            wormInfection = null;
        }
        this.eventMap = this.combineEventArrays(behavioralChange, botnetInfection, cve, excessiveFlows, other, p2p, policyViolation, wormInfection);
        String[] critical = props.getProperty("snort.significancemapping.critical").split(",");
        String[] informational = props.getProperty("snort.significancemapping.informational").split(",");
        String[] important = props.getProperty("snort.significancemapping.important").split(",");
        HashMap<String, String> significance = new HashMap<String, String>();
        int i = 0;
        while (i < critical.length) {
            significance.put(critical[i], "critical");
            ++i;
        }
        i = 0;
        while (i < informational.length) {
            significance.put(informational[i], "informational");
            ++i;
        }
        i = 0;
        while (i < important.length) {
            significance.put(important[i], "important");
            ++i;
        }
        if (significance != null && significance.size() > 0) {
            this.significanceMap = significance;
        }
        this.logBehavioralChange = Boolean.parseBoolean(props.getProperty("snort.eventlog.behavioral_change", "true"));
        this.logBotnetInfection = Boolean.parseBoolean(props.getProperty("snort.eventlog.botnet_infection", "true"));
        this.logCVE = Boolean.parseBoolean(props.getProperty("snort.eventlog.cve", "true"));
        this.logExcessiveFlows = Boolean.parseBoolean(props.getProperty("snort.eventlog.excessive_flows", "true"));
        this.logOther = Boolean.parseBoolean(props.getProperty("snort.eventlog.other", "true"));
        this.logP2P = Boolean.parseBoolean(props.getProperty("snort.eventlog.p2p", "true"));
        this.logPolicyViolation = Boolean.parseBoolean(props.getProperty("snort.eventlog.policy_violation", "true"));
        this.logWormInfection = Boolean.parseBoolean(props.getProperty("snort.eventlog.worm_infection", "true"));
    }

    private boolean checkConfig(String[] propArray) {
        return propArray == null || propArray.length <= 0 || propArray[0].length() != 0;
    }

    private HashMap<String, String> combineEventArrays(String[] behavioralChange, String[] botnetInfection, String[] cve, String[] excessiveFlows, String[] other, String[] p2p, String[] policyViolation, String[] wormInfection) {
        int i;
        HashMap<String, String> eventMap = new HashMap<String, String>();
        if (behavioralChange != null) {
            i = 0;
            while (i < behavioralChange.length) {
                eventMap.put(behavioralChange[i], "behavioral change");
                ++i;
            }
        }
        if (botnetInfection != null) {
            i = 0;
            while (i < botnetInfection.length) {
                eventMap.put(botnetInfection[i], "botnet infection");
                ++i;
            }
        }
        if (cve != null) {
            i = 0;
            while (i < cve.length) {
                eventMap.put(cve[i], "cve");
                ++i;
            }
        }
        if (excessiveFlows != null) {
            i = 0;
            while (i < excessiveFlows.length) {
                eventMap.put(excessiveFlows[i], "excessive flows");
                ++i;
            }
        }
        if (other != null) {
            i = 0;
            while (i < other.length) {
                eventMap.put(other[i], "other");
                ++i;
            }
        }
        if (p2p != null) {
            i = 0;
            while (i < p2p.length) {
                eventMap.put(p2p[i], "p2p");
                ++i;
            }
        }
        if (policyViolation != null) {
            i = 0;
            while (i < policyViolation.length) {
                eventMap.put(policyViolation[i], "policy violation");
                ++i;
            }
        }
        if (wormInfection != null) {
            i = 0;
            while (i < wormInfection.length) {
                eventMap.put(wormInfection[i], "worm infection");
                ++i;
            }
        }
        return eventMap;
    }

    protected Significance getSignificanceValue(int snortPriorityValue) {
        String sigValue = null;
        Significance sign = Significance.informational;
        if (this.significanceMap.containsKey(new Integer(snortPriorityValue).toString())) {
            sigValue = this.significanceMap.get(new Integer(snortPriorityValue).toString());
        }
        if (sigValue != null && sigValue.length() > 0) {
            if (sigValue.startsWith("important")) {
                sign = Significance.important;
            } else if (sigValue.startsWith("informational")) {
                sign = Significance.informational;
            } else if (sigValue.startsWith("critical")) {
                sign = Significance.critical;
            }
        }
        return sign;
    }

    protected EventType getEventMappingForSignatureName(String sigName) {
        String mappedEvent = null;
        mappedEvent = this.eventMap.containsKey(sigName) ? this.eventMap.get(sigName) : "other";
        EventType evntype = EventType.other;
        if (mappedEvent != null && mappedEvent.length() > 0) {
            if (mappedEvent.startsWith("behavioral change")) {
                evntype = EventType.behavioralChange;
            } else if (mappedEvent.startsWith("botnet infection")) {
                evntype = EventType.botnetInfection;
            } else if (mappedEvent.startsWith("cve")) {
                evntype = EventType.cve;
            } else if (mappedEvent.startsWith("excessive flows")) {
                evntype = EventType.excessiveFlows;
            } else if (mappedEvent.startsWith("other")) {
                evntype = EventType.other;
            } else if (mappedEvent.startsWith("p2p")) {
                evntype = EventType.p2p;
            } else if (mappedEvent.startsWith("policy violation")) {
                evntype = EventType.policyViolation;
            } else if (mappedEvent.startsWith("worm infection")) {
                evntype = EventType.wormInfection;
            } else {
                IfMapClient.LOGGER.config("could not map event-type from read in mapping-result: could not find match for " + evntype + " ...using default-type (other)");
            }
        } else {
            IfMapClient.LOGGER.config("could not map event-type from read in mapping-result: empty or non-existing input...using default-type (other)");
        }
        return evntype;
    }

    protected boolean doConvert(EventType eventType) {
        if (eventType == EventType.behavioralChange && !this.logBehavioralChange) {
            return false;
        }
        if (eventType == EventType.botnetInfection && !this.logBotnetInfection) {
            return false;
        }
        if (eventType == EventType.botnetInfection && !this.logCVE) {
            return false;
        }
        if (eventType == EventType.excessiveFlows && !this.logExcessiveFlows) {
            return false;
        }
        if (eventType == EventType.other && !this.logOther) {
            return false;
        }
        if (eventType == EventType.p2p && !this.logP2P) {
            return false;
        }
        if (eventType == EventType.policyViolation && !this.logPolicyViolation) {
            return false;
        }
        return eventType != EventType.wormInfection || this.logWormInfection;
    }
}

