/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.util;

import de.esukom.decoit.ifmapclient.logging.Logging;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Toolbox {
    public static final String REGEX_GENERAL_IP4 = "(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))";
    public static final String REGEX_GENERAL_IP6 = "((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:)))(%.+)?\\s*";
    public static final String REGEX_NAGIOS_PORTPOLLER_ISSTRINGVALID = "((\\w+)=(.+);)+";
    public static final String REGEX_SNORT_ALERTLOG_TYPE = "\\]\\s\\(?[\\w\\s]+\\)?\\:?[a-zA-Z0-9\\s\\<\\>\\/\\-\\*]*\\[";
    public static final String REGEX_SNORT_ALERTLOG_CLASS = "Classification:[\\w\\s]+";
    public static final String REGEX_SNORT_ALERTLOG_PRIORITY = "Priority:\\s\\d";
    public static final String REGEX_SNORT_ALERTLOG_TIMESTAMP = "\\d{2}\\/\\d{2}\\-\\d{2}\\:\\d{2}\\:\\d{2}\\.\\d{6}";
    public static final String REGEX_SNORT_ALERTLOG_VULNARIBILITY_URI = "\\[Xref.+\\]";
    public static final String REGEX_SNORT_PORTSCANLOG_TIMESTAMP = "Time: \\d{2}\\/\\d{2}\\-\\d{2}\\:\\d{2}\\:\\d{2}\\.\\d{6}";
    public static final String REGEX_SNORT_PORTSCANLOG_SOURCE_IP = "(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))\\s->";
    public static final String REGEX_SNORT_PORTSCANLOG_TARGET_IP = "->\\s(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))";
    public static final String REGEX_SNORT_PORTSCANLOG_SCANTYPE = "\\(portscan\\)\\s[\\w\\s]+";
    public static final String REGEX_IPTABLES_ENFORCEMENT_ATTRIBUTE = "(ip|name|significance|confidence|magnitude|message)";
    public static final String REGEX_IPTABLES_ALLOW_ATTRIBUTE = "(role_name|capability_name|device-characteristic_os-version|device-characteristic_os|device-characteristic_model|device-characteristic_manufacturer|device-characteristic_device-type|access-request-ip_ncp-ip-address-type)";
    public static final String REGEX_IPTABLES_FILTERSTRING_DELIMITERS = "\\[.*\\]";
    public static final String REGEX_IPTABLES_ULOG_TIMESTAMP = "\\w*\\s*\\d*\\s\\d*\\:\\d*:\\d*";
    public static final String REGEX_IPTABLES_IFMAP_TIMESTAMP = "\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d\\s\\d\\d\\:\\d\\d\\:\\d\\d";
    public static final String REGEX_RADIUS_DATE = "\\w{3}\\s\\w{3}\\s{1,2}\\d{1,2}\\s\\d{2}:\\d{2}:\\d{2}\\s\\d{4}";
    public static final String REGEX_RADIUS_LOGIN_DEFAULT = "Auth: Login \\w{2,9}(\\s\\(.*\\):)?";
    public static final String REGEX_RADIUS_USER_PW_DEFAULT = "(\\[\\w*(\\/\\w*)?\\])";
    public static final String REGEX_RADIUS_PORT_DEFAULT = "port\\s\\d{1,4}";
    public static final String REGEX_RADIUS_USER_DETAIL = "\\w{4}-\\w{4} = \".*\",";
    public static final String REGEX_RADIUS_ACCTSTATUS = "Acct-Status-Type = \\w*(-\\w*)?";
    public static final String REGEX_RADIUS_ACCTSESSIONID = "Acct-Session-Id = \"\\d*\"";
    public static final String REGEX_RADIUS_ACTT_UNIQUESESSIONID = "Acct-Unique-Session-Id = \"\\w*\"";
    public static Logger sLogger = Logging.getTheLogger();
    public static String sClientStartTime = Toolbox.now();
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";

    public static Pattern getRegExPattern(String regEx) {
        return Pattern.compile(regEx);
    }

    public static String getStringProperty(String property, Properties conf, boolean checkIfFileExists) {
        String propertyValue = conf.getProperty(property, null);
        if (propertyValue == null) {
            sLogger.warning("required property <" + property + "> not found");
            return null;
        }
        if (propertyValue.length() == 0) {
            sLogger.warning("required property <" + property + "> cannot be emtpy");
            return null;
        }
        if (checkIfFileExists) {
            if (new File(propertyValue).exists()) {
                sLogger.info("value for property <" + property + "> is: " + propertyValue);
                return propertyValue;
            }
            sLogger.warning("file for property  <" + property + "> at path " + propertyValue + " doesnt exists");
            return null;
        }
        sLogger.info("value for property <" + property + "> is: " + propertyValue);
        return propertyValue;
    }

    public static String getStringPropertyWithDefault(String property, Properties conf, String defaultValue) {
        String propertyValue = conf.getProperty(property, null);
        if (propertyValue == null) {
            sLogger.warning("required property <" + property + "> not found...using default (" + defaultValue + ")");
            return defaultValue;
        }
        if (propertyValue.length() == 0) {
            sLogger.warning("required property <" + property + "> cannot be emtpy......using default (" + defaultValue + ")");
            return defaultValue;
        }
        sLogger.info("value for property <" + property + "> is: " + propertyValue);
        return propertyValue;
    }

    public static int getIntPropertyWithDefault(String property, int defaultValue, Properties conf, boolean withoutZero) {
        int returnValue;
        String propertyValue = conf.getProperty(property, null);
        if (propertyValue == null || propertyValue.length() == 0) {
            sLogger.warning("property  <" + property + "> is empty or null...using default value (" + defaultValue + ")");
            return defaultValue;
        }
        if (withoutZero && propertyValue.equals("0")) {
            sLogger.warning("property  <" + property + "> cannot be zero...using default value (" + defaultValue + ")");
            return defaultValue;
        }
        try {
            returnValue = Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            sLogger.warning("property <" + property + "> must be an integer...using default value (" + defaultValue + ")");
            return defaultValue;
        }
        sLogger.info("value for property <" + property + "> is: " + returnValue);
        return returnValue;
    }

    public static boolean getBoolPropertyWithDefault(String property, boolean defaultValue, Properties conf) {
        String propertyValue = conf.getProperty(property, null);
        if (propertyValue == null || propertyValue.length() == 0) {
            sLogger.warning("property  <" + property + "> is empty or null...using default value (" + defaultValue + ")");
            return defaultValue;
        }
        boolean returnValue = Boolean.parseBoolean(propertyValue);
        sLogger.info("value for property <" + property + "> is: " + returnValue);
        return returnValue;
    }

    public static boolean checkConfig(String[] propArray) {
        return propArray == null || propArray.length <= 0 || propArray[0].length() != 0;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    public static Calendar getCalendarFromString(String dateString) {
        Date date = null;
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_NOW);
        try {
            date = formatter.parse(dateString);
        }
        catch (ParseException e) {
            System.err.println("Error while creating Calendar From String!");
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String getCurrentYear() {
        return new Integer(new GregorianCalendar().get(1)).toString();
    }

    public static String convertIP6AddressToIFMAPIP6AddressPattern(String adr) {
        String[] singleEntrys = adr.split(":");
        String convertedAddress = new String();
        int i = 0;
        while (i < singleEntrys.length) {
            singleEntrys[i] = singleEntrys[i].replaceFirst("0*", "");
            if (singleEntrys[i].length() < 1) {
                singleEntrys[i] = "0";
            }
            if (i != singleEntrys.length - 1) {
                int n = i;
                singleEntrys[n] = String.valueOf(singleEntrys[n]) + ":";
            }
            convertedAddress = String.valueOf(convertedAddress) + singleEntrys[i];
            ++i;
        }
        return convertedAddress;
    }

    public static void printLogo() {
        System.out.println(" +-----------------------------------------------------+");
        System.out.println(" |                   _                                 |");
        System.out.println(" |                  | |                                |");
        System.out.println(" |    ___  ___ _   _| | _____  _ __ ___                |");
        System.out.println(" |   / _ \\/ __| | | | |/ / _ \\| '_ ` _ \\               |");
        System.out.println(" |  |  __/\\__ \\ |_| |   < (_) | | | | | |              |");
        System.out.println(" |   \\___||___/\\__,_|_|\\_\\___/|_| |_| |_|              |");
        System.out.println(" |                                                     |");
        System.out.println(" |  DECOIT IF-MAP-CLIENT (VERSION 0.1.5)               |");
        System.out.println(" |  (c)2011 DECOIT GmbH (www.decoit.de)                |");
        System.out.println(" |                                                     |");
        System.out.println(" |  developed within the ESUKOM-Project(www.esukom.de) |");
        System.out.println(" |  licensed to the Apache Software Foundation (ASF)   |");
        System.out.println(" |                                                     |");
        System.out.println(" |  see README for more details                        |");
        System.out.println(" |                                                     |");
        System.out.println(" +-----------------------------------------------------+\n\n\n");
    }
}

