/* 
 * SnortBarnyardFilePollingThread.java        0.1.4 12/02/16
 * 
 * DEVELOPED BY DECOIT GMBH WITHIN THE ESUKOM-PROJECT:
 * http://www.decoit.de/
 * http://www.esukom.de/cms/front_content.php?idcat=10&lang=1
 * 
 * DERIVED FROM  THE DHCP-IFMAP-CLIENT-IMPLEMENTATION DEVELOPED BY 
 * FHH/TRUST WITHIN THE IRON-PROJECT:
 * http://trust.inform.fh-hannover.de/joomla/
 * 
 * Licensed to the Apache Software Foundation (ASF) under one 
 * or more contributor license agreements.  See the NOTICE file 
 * distributed with this work for additional information 
 * regarding copyright ownership.  The ASF licenses this file 
 * to you under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License.  You may obtain a copy of the License at 
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
 * KIND, either express or implied.  See the License for the 
 * specific language governing permissions and limitations 
 * under the License. 
 */

package de.esukom.decoit.ifmapclient.pollingthreads;

import de.esukom.decoit.ifmapclient.main.IfMapClient;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

/**
 * Thread for polling the Alertlog-File for new Snort-Events
 * 
 * @version 0.1.4
 * @author Dennis Dunekacke, Decoit GmbH
 */
public class SnortFilePollingThread extends FilePollingThread {

    /**
     * constructor
     * 
     * @param path
     *            path of snort-log-file
     */
    public SnortFilePollingThread(Properties pr) {
        // initialize properties
        initProperties(pr);
    }

    /**
     * read and parse alert-log-file
     */
    @Override
    protected ArrayList<HashMap<String, String>> readFile() {
        // used for distinction of the different lines of a single
        // event entry inside log-file while parsing
        int currentLineInSingleEntry = 0;

        // number of read lines in current cycle, used to determine
        // current position inside file (in terms of already read lines )
        int currentCycleLineNumber = 0;

        BufferedReader input = null;
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();

        HashMap<String, String> tempEventData = new HashMap<String, String>();

        try {
            input = new BufferedReader(new FileReader(file), 1);
            String line = null;
            while ((line = input.readLine()) != null) {
                if (isFirstStart) {
                    lastEntryLineNumber++;
                }
                currentCycleLineNumber++;
                if (isFirstStart | currentCycleLineNumber > lastEntryLineNumber) {
                    // new event entry in log-file detected
                    if (line.startsWith("[**]")) {
                        // convert last entry
                        if (!tempEventData.isEmpty()) {

                            // clone! otherwise you will get a reference-problem
                            // after clearing tempEventData
                            result.add((HashMap<String, String>) tempEventData.clone());

                            // reset entries from last cycle
                            tempEventData.clear();
                        }
                        // reset current entry line counter
                        currentLineInSingleEntry = 0;
                    }

                    tempEventData.put(new Integer(currentLineInSingleEntry).toString(), line);
                    currentLineInSingleEntry++;
                }
            }

            // loop over, add last remaining entry
            if (!tempEventData.isEmpty()) {
                result.add(tempEventData);
            }

            if (!isFirstStart) {
                // set new last entry index
                lastEntryLineNumber = currentCycleLineNumber;
            } else {
                // first cycle finished
                isFirstStart = false;
            }
        } catch (FileNotFoundException ex) {
            ex.printStackTrace();
            IfMapClient
                    .exit("error while opening snort log-file...the file does not exists, please check your configuration");
        } catch (IOException ex) {
            ex.printStackTrace();
            IfMapClient.exit("I/O error while reading snort log-file");
        } finally {
            try {
                input.close();
            } catch (IOException e) {
                e.printStackTrace();
                IfMapClient
                        .exit("error while closing input buffer after trying to read snort log-file");
            }
        }

        return result;
    }
}