   /*            
    * RadiusEventMappingFactory.java        0.1.4 12/02/16
    * 
    * DEVELOPED BY DECOIT GMBH WITHIN THE ESUKOM-PROJECT:
    * http://www.decoit.de/
    * http://www.esukom.de/cms/front_content.php?idcat=10&lang=1
    * 
    * DERIVED FROM  THE DHCP-IFMAP-CLIENT-IMPLEMENTATION DEVELOPED BY 
    * FHH/TRUST WITHIN THE IRON-PROJECT:
    * http://trust.inform.fh-hannover.de/joomla/
    * 
    * Licensed to the Apache Software Foundation (ASF) under one 
    * or more contributor license agreements.  See the NOTICE file 
    * distributed with this work for additional information 
    * regarding copyright ownership.  The ASF licenses this file 
    * to you under the Apache License, Version 2.0 (the 
    * "License"); you may not use this file except in compliance 
    * with the License.  You may obtain a copy of the License at 
    * 
    *   http://www.apache.org/licenses/LICENSE-2.0 
    * 
    * Unless required by applicable law or agreed to in writing, 
    * software distributed under the License is distributed on an 
    * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
    * KIND, either express or implied.  See the License for the 
    * specific language governing permissions and limitations 
    * under the License. 
    */

package de.esukom.decoit.ifmapclient.mappingfactory;


import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import de.fhhannover.inform.trust.ifmapj.metadata.Significance;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * concrete implementation of abstract mapping-factory for mapping values from
 * polling-threads to event objects that can be send to MAP-Server
 * 
 * @author Marcel Jahnke, DECOIT GmbH
 * 
 */
public class RadiusEventMappingFactory extends MappingFactory {
	
	private EventType mEventtypeDefault;
    private String mMagnitudeDefault;
    private String mConfidenceDefault;
    private Significance mSignificanceDefault;

	public RadiusEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
		super(props, data);
	}

	
	@Override
	protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> data) {

		initProperties(props);
		SimpleDateFormat ifmapTimeStyle = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss'Z'");
		SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.ENGLISH);
		SimpleDateFormat dateFormat2 = new SimpleDateFormat(Toolbox.DATE_FORMAT_NOW);
		for (int i = 0; i < data.size(); i++) {
			HashMap<String, String> temp = data.get(i);
			for (int j = 1; j <= temp.size(); j++) {

				if (temp.get(String.valueOf(j)) != null) {
					Calendar date = null;
					Matcher dateMatcher = Toolbox.getRegExPattern(Toolbox.REGEX_RADIUS_DATE).matcher(temp.get(String.valueOf(j)));
					Date datum = null;
					if (dateMatcher.find()) {
						try {
							datum = dateFormat.parse(dateMatcher.group());
							date = Toolbox.getCalendarFromString(dateFormat2.format(datum));
						} catch (ParseException e) {
							e.printStackTrace();
						}
						Calendar calender = Toolbox.getCalendarFromString(Toolbox.sClientStartTime);
						if (date.compareTo(calender) >= 0) {
							EventMappingResult event = new EventMappingResult();
							event.setDiscoveredTime(ifmapTimeStyle.format(datum));

							// Matcher loginMatcher =
							// Toolbox.getRegExPattern(Toolbox.REGEX_RADIUS_LOGIN).matcher(temp.get(String.valueOf(j)));
							// if(loginMatcher.find()){
							//					
							// }

							Matcher user_pw = Pattern.compile(Toolbox.REGEX_RADIUS_USER_PW_DEFAULT).matcher(temp.get(String.valueOf(j)));
							if (user_pw.find()) {
								int pos = user_pw.group().indexOf("/");
								event.setIdentity(user_pw.group()/*
																 * .subSequence(0
																 * ,
																 * pos).toString
																 * ()
																 */);
								// System.out.println(event.getIdentity());
							}
							user_pw = Pattern.compile(Toolbox.REGEX_RADIUS_USER_DETAIL).matcher(temp.get(String.valueOf(j)));
							if (user_pw.find()) {
								event.setIdentity(user_pw.group().replace("User-Name = ", "").replace(",", ""));
							}

							Matcher ipMatcher = Toolbox.getRegExPattern(Toolbox.REGEX_GENERAL_IP4).matcher(
									temp.get(String.valueOf(j)).replace("localhost", "127.0.0.1"));
							if (ipMatcher.find()) {
								event.setIp(ipMatcher.group());
								// System.out.println(event.getIp());
								event.setIpType("IPv4");
							}
							Matcher typeMatcher = Toolbox.getRegExPattern(Toolbox.REGEX_RADIUS_LOGIN_DEFAULT).matcher(temp.get(String.valueOf(j)));
							if (typeMatcher.find()) {
								event.setName(typeMatcher.group());
								// System.out.println(event.getName());
							}
							typeMatcher = Toolbox.getRegExPattern(Toolbox.REGEX_RADIUS_ACCTSTATUS).matcher(temp.get(String.valueOf(j)));
							if (typeMatcher.find()) {
								event.setName(typeMatcher.group());
							}
							else {
								event.setName("Acct");
							}

							event.setConfidence(mConfidenceDefault);
							event.setMagnitude(mMagnitudeDefault);
							event.setSignificance(mSignificanceDefault);
							event.setEventMessageType(mEventtypeDefault);
							
//							event.setConfidence("60");
//							event.setMagnitude("100");
//							event.setSignificance(Significance.important);
//							event.setEventMessageType(EventType.behavioralChange);

							// Matcher portMatcher =
							// Pattern.compile(REGEX_RADIUS_PORT).matcher(resultObject.get(i).get(String.valueOf(j)));
							// if(portMatcher.find()){
							// System.out.println(portMatcher.group());
							// }
							super.mapResult.add(event);
						}
					}

				}

			}
		}
		for (int i = 0; i < mapResult.size(); i++) {
			System.out.println(mapResult.get(i).showOnConsole());
		}
	}
	
	/**
     * initialize config from property-file
     * 
     * @param conf
     *            properties-object
     */
    public void initProperties(Properties props) {
        boolean criticalErrorOcured = false;

        // event to be processed/mapped
        mEventtypeDefault = EventType.behavioralChange; // default!

        String eventTypeFromConfig = Toolbox.getStringProperty("radius.eventmapping.eventtype",
                props, false);
       
        if (mEventtypeDefault == null) {
            criticalErrorOcured = true;
        }

        // map event-type-string to ifmaplibj EventType-type
        if (eventTypeFromConfig == "botnet-infection") {
            mEventtypeDefault = EventType.botnetInfection;

        } else if (eventTypeFromConfig == "cve") {
            mEventtypeDefault = EventType.cve;

        } else if (eventTypeFromConfig == "excessive-flows") {
            mEventtypeDefault = EventType.excessiveFlows;

        } else if (eventTypeFromConfig == "other") {
            mEventtypeDefault = EventType.other;

        } else if (eventTypeFromConfig == "p2p") {
            mEventtypeDefault = EventType.p2p;

        } else if (eventTypeFromConfig == "policy-violation") {
            mEventtypeDefault = EventType.policyViolation;

        } else if (eventTypeFromConfig == "worm-infection") {
            mEventtypeDefault = EventType.wormInfection;

        } else {
            IfMapClient.LOGGER
                    .config("could not load default event-type value from nagios mapping config...using default (behavioral-change)");
        }

        // magnitude mapping
        mMagnitudeDefault = Toolbox
                .getStringProperty("radius.eventmapping.magnitude", props, false);
        if (mMagnitudeDefault == null) {
            criticalErrorOcured = true;
        }

        // confidence mapping
        mConfidenceDefault = Toolbox.getStringProperty("radius.eventmapping.confidence", props,
                false);
        if (mConfidenceDefault == null) {
            criticalErrorOcured = true;
        }

        // significance mapping
        mSignificanceDefault = Significance.informational; // default!
        String significanceFromConfig = Toolbox.getStringProperty(
                "radius.eventmapping.significance", props, false);

        // map significance-string to ifmaplibj significance datatype
        if (significanceFromConfig == "important") {
            mSignificanceDefault = Significance.important;

        } else if (significanceFromConfig == "critical") {
            mSignificanceDefault = Significance.critical;

        } else {
            IfMapClient.LOGGER
                    .config("could not load default significance value from nagios mapping config...using default (informational)");
        }

        if (criticalErrorOcured) {
            IfMapClient.exit("error while initializing NagiosEventMappingFactory");
        }
    }
}
