/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.main;

import de.esukom.decoit.ifmapclient.config.BasicPropertiesReader;
import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.config.GeneralPropertiesReader;
import de.esukom.decoit.ifmapclient.iptables.IPTablesFacade;
import de.esukom.decoit.ifmapclient.logging.Logging;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingFactory;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingResult;
import de.esukom.decoit.ifmapclient.messaging.IFMAPMessagingFacade;
import de.esukom.decoit.ifmapclient.pollingthreads.IPTablesULogFilePollingThread;
import de.esukom.decoit.ifmapclient.pollingthreads.PollingThread;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class IfMapClient
implements Observer {
    public static final Logger LOGGER = Logging.getTheLogger();
    public static String sMapServerIP = null;
    public static String sClientIP = null;
    public static String[] sInputConfigParams = null;
    private PollingThread mPollingThread;
    private final String mDefaultConfigPath = "config/config.properties";

    public IfMapClient(String[] args) {
        Toolbox.printLogo();
        if (args != null && args.length > 0) {
            sInputConfigParams = args;
        }
        this.init();
    }

    private void init() {
        this.initConfigFiles();
        Matcher ipMatcher = Toolbox.getRegExPattern("(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))").matcher(GeneralConfig.MAPSERVER_URL);
        if (ipMatcher.find()) {
            sMapServerIP = ipMatcher.group();
        } else {
            IfMapClient.exit("error while parsing ip-address of map-server from general configuration...please check your configuration");
        }
        sClientIP = GeneralConfig.APPLICATION_IPADDRESS;
        if (!sClientIP.equals("unknown")) {
            LOGGER.config("IP-Address for this Machine (as defined in config.properties) -> " + sClientIP);
        } else {
            IfMapClient.exit("no ip-address for this machine found in config.properties...please check your configuration");
        }
        this.initMessagingFacade();
        this.initPollingThreads();
        if (this.mPollingThread instanceof IPTablesULogFilePollingThread) {
            this.initIpTablesFacade();
            IPTablesFacade.getInstance().executeIPTableStartRules(IFMAPMessagingFacade.getInstance().mapServerIP);
        }
        this.initShutdownHook();
    }

    private void initConfigFiles() {
        if (new File("config/config.properties").exists()) {
            LOGGER.info("loading configuration files from config/config.properties...");
            GeneralPropertiesReader.loadProperties("config/config.properties");
            BasicPropertiesReader.loadProperties(GeneralConfig.APPLICATION_POLLINGCONFIG_PATH);
            BasicPropertiesReader.loadProperties(GeneralConfig.APPLICATION_MAPPINGCONFIG_PATH);
        } else {
            IfMapClient.exit("could not find main configuration file at: config/config.properties...please check if it exists");
        }
    }

    private void initMessagingFacade() {
        LOGGER.info("initializing messaging facade with map-server-ip " + sMapServerIP + "...");
        IFMAPMessagingFacade.getInstance().init(sMapServerIP);
    }

    private void initIpTablesFacade() {
        LOGGER.info("initializing iptables facade...");
        BasicPropertiesReader.loadProperties("config/iptables/enforcement.properties");
        IPTablesFacade.getInstance().init(BasicPropertiesReader.getProperties());
    }

    private void initPollingThreads() {
        LOGGER.info("initializing polling thread using class: " + GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME + "...");
        if (BasicPropertiesReader.getProperties() == null) {
            IfMapClient.exit("no properties found...check your configuration in polling.properties");
        }
        Class<?> pollingClass = null;
        try {
            pollingClass = Class.forName(GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            IfMapClient.exit("no valid polling-class found...check your configuration in config.properties");
        }
        Constructor<?> constructor = null;
        try {
            constructor = pollingClass.getConstructor(Properties.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            IfMapClient.exit("could not get constructor for class " + GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME + "...check your configuration");
        }
        try {
            this.mPollingThread = (PollingThread)constructor.newInstance(BasicPropertiesReader.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
            IfMapClient.exit("could not create new polling-class from " + GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME + "...check your configuration");
        }
        this.mPollingThread.sleepTime = GeneralConfig.APPLICATION_POLLING_INTERVAL * 1000;
        this.mPollingThread.addObserver(this);
    }

    private void initShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    IFMAPMessagingFacade.getInstance().sendEndSessionRequest();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IfMapClient.exit("error while initializing shutdown-hook!");
                }
            }
        });
    }

    public void start() {
        int retries;
        LOGGER.info("trying to connect to MAP-Server at: " + GeneralConfig.MAPSERVER_URL + "...");
        int retriesLeft = retries = GeneralConfig.APPLICATION_CONNECTION_RETRYCOUNT;
        boolean connected = false;
        while (retriesLeft > 0) {
            IFMAPMessagingFacade.getInstance().sendNewSessionRequest();
            IFMAPMessagingFacade.getInstance().sendPurgePublishRequest();
            connected = true;
            if (connected) break;
            LOGGER.warning("could not established connection...retrying (" + (retriesLeft - 1) + " left)");
            --retriesLeft;
        }
        if (connected) {
            LOGGER.info("connection  established with publisher-id: " + IFMAPMessagingFacade.getInstance().getIFMAPPublisherId());
        } else {
            IfMapClient.exit("error while sending initial purgePublish " + retries + " times...giving up!");
        }
        if (this.mPollingThread != null) {
            LOGGER.info("starting polling-thread at " + Toolbox.now());
            this.mPollingThread.running = true;
            this.mPollingThread.pausing = false;
            new Thread(this.mPollingThread).start();
        } else {
            IfMapClient.exit("polling-thread is not initialized and therefore cannot be started");
        }
        if (GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME.equals("de.esukom.decoit.ifmapclient.pollingthreads.IPTablesULogFilePollingThread") && GeneralConfig.APPLICATION_ARCPOLLING_ENABLED && GeneralConfig.APPLICATION_IPTABLES_MODE.equalsIgnoreCase("esukom")) {
            IFMAPMessagingFacade.getInstance().subscribeToAlertEvents();
        }
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        LOGGER.info("polling-thread notifies observer about new result!");
        if (o != null) {
            ArrayList tmpResultList = (ArrayList)arg;
            if (tmpResultList != null) {
                MappingFactory mappingFactory = null;
                LOGGER.info("creating mapping factory for: " + GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME);
                mappingFactory = this.getMappingFactory(tmpResultList, GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME);
                if (mappingFactory != null) {
                    MappingResult[] resultList = mappingFactory.getMappingResult();
                    if (resultList != null && resultList.length > 0) {
                        if (o instanceof IPTablesULogFilePollingThread) {
                            if (GeneralConfig.APPLICATION_ARCPOLLING_ENABLED) {
                                if (GeneralConfig.APPLICATION_IPTABLES_MODE.equalsIgnoreCase("esukom")) {
                                    IFMAPMessagingFacade.getInstance().checkEntriesForAllowance(resultList);
                                } else if (IFMAPMessagingFacade.getInstance().pollingClientList.addNewClientsToClientList(resultList)) {
                                    IFMAPMessagingFacade.getInstance().updateSubscribtions();
                                    LOGGER.info("sending data to MAP-Server at " + GeneralConfig.MAPSERVER_URL);
                                    if (GeneralConfig.APPLICATION_IPTABLES_SENDDATASTREAMDETECTEDEVENT) {
                                        IFMAPMessagingFacade.getInstance().sendPublishEventRequest(resultList);
                                    }
                                }
                            }
                        } else {
                            LOGGER.info("sending data to MAP-Server at " + GeneralConfig.MAPSERVER_URL);
                            IFMAPMessagingFacade.getInstance().sendPublishEventRequest(resultList);
                            LOGGER.info("done sending data to MAP-Server at " + GeneralConfig.MAPSERVER_URL);
                        }
                    } else {
                        LOGGER.info("mapping result is null or empty, not sending anything to server");
                    }
                } else {
                    LOGGER.warning("cannot get result from mapping factory because its not initialized");
                }
            } else {
                LOGGER.warning("result from " + GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME + " is null after casting, nothing to send to server!");
            }
        } else {
            LOGGER.info("result from " + GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME + " is null, nothing to send to server!");
        }
        this.mPollingThread.pausing = false;
    }

    private MappingFactory getMappingFactory(ArrayList<HashMap<String, String>> data, String mappingConfigClassName) {
        if (data != null) {
            Class<?> mappingClass = null;
            try {
                mappingClass = Class.forName(mappingConfigClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                IfMapClient.exit("could not find MappingClass...check your config.properties for errors!");
            }
            Constructor<?> constructor = null;
            try {
                constructor = mappingClass.getConstructor(Properties.class, ArrayList.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("could not get Constructor of MappingClass");
            }
            MappingFactory mappingFactory = null;
            try {
                mappingFactory = (MappingFactory)constructor.newInstance(BasicPropertiesReader.getProperties(), data);
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("could not create MappingFactory");
            }
            return mappingFactory;
        }
        LOGGER.warning("could not create mapping factory from empty result");
        return null;
    }

    public static void main(String[] args) {
        IfMapClient client = new IfMapClient(args);
        client.start();
    }

    public static void exit(String errorMsg) {
        if (errorMsg != null) {
            LOGGER.severe("client ended due to error with message: " + errorMsg);
            System.exit(1);
        } else {
            LOGGER.info("client ended normaly...bye bye :-)");
            System.exit(0);
        }
    }
}

