/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingFactory;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingResult;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import de.fhhannover.inform.trust.ifmapj.metadata.Significance;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RadiusEventMappingFactory
extends MappingFactory {
    private EventType mEventtypeDefault;
    private String mMagnitudeDefault;
    private String mConfidenceDefault;
    private Significance mSignificanceDefault;

    public RadiusEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> data) {
        this.initProperties(props);
        SimpleDateFormat ifmapTimeStyle = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss'Z'");
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.ENGLISH);
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int i = 0;
        while (i < data.size()) {
            HashMap<String, String> temp = data.get(i);
            int j = 1;
            while (j <= temp.size()) {
                if (temp.get(String.valueOf(j)) != null) {
                    Calendar date = null;
                    Matcher dateMatcher = Toolbox.getRegExPattern("\\w{3}\\s\\w{3}\\s{1,2}\\d{1,2}\\s\\d{2}:\\d{2}:\\d{2}\\s\\d{4}").matcher(temp.get(String.valueOf(j)));
                    Date datum = null;
                    if (dateMatcher.find()) {
                        try {
                            datum = dateFormat.parse(dateMatcher.group());
                            date = Toolbox.getCalendarFromString(dateFormat2.format(datum));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        Calendar calender = Toolbox.getCalendarFromString(Toolbox.sClientStartTime);
                        if (date.compareTo(calender) >= 0) {
                            Matcher typeMatcher;
                            Matcher ipMatcher;
                            EventMappingResult event = new EventMappingResult();
                            event.setDiscoveredTime(ifmapTimeStyle.format(datum));
                            Matcher user_pw = Pattern.compile("(\\[\\w*(\\/\\w*)?\\])").matcher(temp.get(String.valueOf(j)));
                            if (user_pw.find()) {
                                int pos = user_pw.group().indexOf("/");
                                event.setIdentity(user_pw.group());
                            }
                            if ((user_pw = Pattern.compile("\\w{4}-\\w{4} = \".*\",").matcher(temp.get(String.valueOf(j)))).find()) {
                                event.setIdentity(user_pw.group().replace("User-Name = ", "").replace(",", ""));
                            }
                            if ((ipMatcher = Toolbox.getRegExPattern("(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))").matcher(temp.get(String.valueOf(j)).replace("localhost", "127.0.0.1"))).find()) {
                                event.setIp(ipMatcher.group());
                                event.setIpType("IPv4");
                            }
                            if ((typeMatcher = Toolbox.getRegExPattern("Auth: Login \\w{2,9}(\\s\\(.*\\):)?").matcher(temp.get(String.valueOf(j)))).find()) {
                                event.setName(typeMatcher.group());
                            }
                            if ((typeMatcher = Toolbox.getRegExPattern("Acct-Status-Type = \\w*(-\\w*)?").matcher(temp.get(String.valueOf(j)))).find()) {
                                event.setName(typeMatcher.group());
                            } else {
                                event.setName("Acct");
                            }
                            event.setConfidence(this.mConfidenceDefault);
                            event.setMagnitude(this.mMagnitudeDefault);
                            event.setSignificance(this.mSignificanceDefault);
                            event.setEventMessageType(this.mEventtypeDefault);
                            this.mapResult.add(event);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.mapResult.size()) {
            System.out.println(((MappingResult)this.mapResult.get(i)).showOnConsole());
            ++i;
        }
    }

    @Override
    public void initProperties(Properties props) {
        boolean criticalErrorOcured = false;
        this.mEventtypeDefault = EventType.behavioralChange;
        String eventTypeFromConfig = Toolbox.getStringProperty("radius.eventmapping.eventtype", props, false);
        if (this.mEventtypeDefault == null) {
            criticalErrorOcured = true;
        }
        if (eventTypeFromConfig == "botnet-infection") {
            this.mEventtypeDefault = EventType.botnetInfection;
        } else if (eventTypeFromConfig == "cve") {
            this.mEventtypeDefault = EventType.cve;
        } else if (eventTypeFromConfig == "excessive-flows") {
            this.mEventtypeDefault = EventType.excessiveFlows;
        } else if (eventTypeFromConfig == "other") {
            this.mEventtypeDefault = EventType.other;
        } else if (eventTypeFromConfig == "p2p") {
            this.mEventtypeDefault = EventType.p2p;
        } else if (eventTypeFromConfig == "policy-violation") {
            this.mEventtypeDefault = EventType.policyViolation;
        } else if (eventTypeFromConfig == "worm-infection") {
            this.mEventtypeDefault = EventType.wormInfection;
        } else {
            IfMapClient.LOGGER.config("could not load default event-type value from nagios mapping config...using default (behavioral-change)");
        }
        this.mMagnitudeDefault = Toolbox.getStringProperty("radius.eventmapping.magnitude", props, false);
        if (this.mMagnitudeDefault == null) {
            criticalErrorOcured = true;
        }
        this.mConfidenceDefault = Toolbox.getStringProperty("radius.eventmapping.confidence", props, false);
        if (this.mConfidenceDefault == null) {
            criticalErrorOcured = true;
        }
        this.mSignificanceDefault = Significance.informational;
        String significanceFromConfig = Toolbox.getStringProperty("radius.eventmapping.significance", props, false);
        if (significanceFromConfig == "important") {
            this.mSignificanceDefault = Significance.important;
        } else if (significanceFromConfig == "critical") {
            this.mSignificanceDefault = Significance.critical;
        } else {
            IfMapClient.LOGGER.config("could not load default significance value from nagios mapping config...using default (informational)");
        }
        if (criticalErrorOcured) {
            IfMapClient.exit("error while initializing NagiosEventMappingFactory");
        }
    }
}

