/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingFactory;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import de.fhhannover.inform.trust.ifmapj.metadata.Significance;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;

public class IPTablesEventMappingFactory
extends MappingFactory {
    private EventType mEventtypeDefault;
    private String mMagnitudeDefault;
    private String mConfidenceDefault;
    private Significance mSignificanceDefault;
    private int mDuplicateEntriesTimeDelay;

    public IPTablesEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void initProperties(Properties props) {
        boolean criticalErrorOcured = false;
        this.mEventtypeDefault = EventType.behavioralChange;
        String eventTypeFromConfig = Toolbox.getStringProperty("iptables.eventmapping.eventtype", props, false);
        if (this.mEventtypeDefault == null) {
            criticalErrorOcured = true;
        }
        if (eventTypeFromConfig == "botnet-infection") {
            this.mEventtypeDefault = EventType.botnetInfection;
        } else if (eventTypeFromConfig == "cve") {
            this.mEventtypeDefault = EventType.cve;
        } else if (eventTypeFromConfig == "excessive-flows") {
            this.mEventtypeDefault = EventType.excessiveFlows;
        } else if (eventTypeFromConfig == "other") {
            this.mEventtypeDefault = EventType.other;
        } else if (eventTypeFromConfig == "p2p") {
            this.mEventtypeDefault = EventType.p2p;
        } else if (eventTypeFromConfig == "policy-violation") {
            this.mEventtypeDefault = EventType.policyViolation;
        } else if (eventTypeFromConfig == "worm-infection") {
            this.mEventtypeDefault = EventType.wormInfection;
        } else {
            IfMapClient.LOGGER.config("could not load default event-type value from iptables mapping config...using default (behavioral-change)");
        }
        this.mMagnitudeDefault = Toolbox.getStringProperty("iptables.eventmapping.magnitude", props, false);
        if (this.mMagnitudeDefault == null) {
            criticalErrorOcured = true;
        }
        this.mConfidenceDefault = Toolbox.getStringProperty("iptables.eventmapping.confidence", props, false);
        if (this.mConfidenceDefault == null) {
            criticalErrorOcured = true;
        }
        this.mSignificanceDefault = Significance.informational;
        String significanceFromConfig = Toolbox.getStringProperty("iptables.eventmapping.significance", props, false);
        if (significanceFromConfig == "important") {
            this.mSignificanceDefault = Significance.important;
        } else if (significanceFromConfig == "critical") {
            this.mSignificanceDefault = Significance.critical;
        } else {
            IfMapClient.LOGGER.config("could not load default significance value from iptables mapping config...using default (informational)");
        }
        this.mDuplicateEntriesTimeDelay = Toolbox.getIntPropertyWithDefault("iptables.eventmapping.timedelay", 0, props, false);
        if (criticalErrorOcured) {
            IfMapClient.exit("error while initializing iptables-EventMappingFactory");
        }
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> res) {
        this.initProperties(props);
        boolean isFirstEntry = true;
        String prevDiscTime = null;
        int i = 0;
        while (i < res.size()) {
            String discTime = null;
            EventMappingResult event = new EventMappingResult();
            Matcher timestampMatcher = Toolbox.getRegExPattern("\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d\\s\\d\\d\\:\\d\\d\\:\\d\\d").matcher(res.get(i).get("0"));
            if (timestampMatcher == null || !timestampMatcher.find()) {
                IfMapClient.LOGGER.warning("could not find timestamp for entry[" + i + "]...skipping entry");
            } else {
                discTime = timestampMatcher.group();
                String dstIp = null;
                Matcher srcMatcher = Toolbox.getRegExPattern("SRC=(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))").matcher(res.get(i).get("0"));
                if (srcMatcher == null || !srcMatcher.find()) {
                    IfMapClient.LOGGER.warning("could not find source ip for entry[" + i + "]...skipping entry");
                } else {
                    String srcIp = srcMatcher.group().replace("SRC=", "");
                    event.setIp(srcIp);
                    Matcher dstMatcher = Toolbox.getRegExPattern("DST=(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))").matcher(res.get(i).get("0"));
                    if (dstMatcher != null && dstMatcher.find()) {
                        dstIp = dstMatcher.group().replace("DST=", "");
                    } else {
                        IfMapClient.LOGGER.warning("could not find destination ip for entry[" + i + "]...using default (not detected)");
                        dstIp = "not detected";
                    }
                    if (srcIp.equals(IfMapClient.sMapServerIP) & dstIp.equals(IfMapClient.sClientIP) || srcIp.equals(IfMapClient.sClientIP) & dstIp.equals(IfMapClient.sMapServerIP)) {
                        IfMapClient.LOGGER.fine("Event is Datastream  between Server and Client (src=" + srcIp + ",dst=" + dstIp + "...not publishing Event!");
                    } else {
                        event.setName("datastream detected from " + srcIp + " to " + dstIp);
                        boolean insertEntry = false;
                        if (!isFirstEntry) {
                            int j = 0;
                            while (j < this.mapResult.size()) {
                                EventMappingResult tempEvent = (EventMappingResult)this.mapResult.get(j);
                                if (tempEvent.getName().equals(event.getName()) & tempEvent.getIp().equals(event.getIp())) {
                                    Calendar prevCalendar = Toolbox.getCalendarFromString(prevDiscTime);
                                    prevCalendar.add(13, this.mDuplicateEntriesTimeDelay * -1);
                                    if (Toolbox.getCalendarFromString(discTime).after(prevCalendar)) {
                                        this.mapResult.remove(j);
                                        insertEntry = true;
                                    } else {
                                        prevDiscTime = discTime;
                                    }
                                } else {
                                    insertEntry = true;
                                }
                                ++j;
                            }
                        } else {
                            isFirstEntry = false;
                            insertEntry = true;
                        }
                        if (insertEntry) {
                            event.setDiscovererId(SOAPMessageSender.getInstance().getIfMapPublisherId());
                            event.setSignificance(this.mSignificanceDefault);
                            event.setEventMessageType(this.mEventtypeDefault);
                            event.setConfidence(this.mConfidenceDefault);
                            event.setMagnitude(this.mMagnitudeDefault);
                            event.setIpType("IPv4");
                            prevDiscTime = discTime;
                            event.setDiscoveredTime(this.convertDateToIFMAPDate(discTime));
                            this.mapResult.add(event);
                            IfMapClient.LOGGER.fine("mapped iptables event has been added to result list: " + event.showOnConsole());
                        }
                    }
                }
            }
            ++i;
        }
    }

    private String convertDateToIFMAPDate(String currentDate) {
        String[] timestamp = currentDate.split(" ");
        String[] date = timestamp[0].split("-");
        return String.valueOf(date[0]) + "-" + date[1] + "-" + date[2] + "T" + timestamp[1] + "Z";
    }
}

