/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.messaging;

import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.iptables.IPTablesFacade;
import de.esukom.decoit.ifmapclient.iptables.RulesExecutor;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingResult;
import de.esukom.decoit.ifmapclient.messaging.IFMAPMessagePollingThread;
import de.esukom.decoit.ifmapclient.messaging.PollingClientList;
import de.esukom.decoit.ifmapclient.messaging.PollingClientListEntry;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.fhhannover.inform.trust.ifmapj.channel.ARC;
import de.fhhannover.inform.trust.ifmapj.exception.IfmapErrorResult;
import de.fhhannover.inform.trust.ifmapj.exception.IfmapException;
import de.fhhannover.inform.trust.ifmapj.exception.InitializationException;
import de.fhhannover.inform.trust.ifmapj.messages.PollResult;
import de.fhhannover.inform.trust.ifmapj.messages.ResultItem;
import de.fhhannover.inform.trust.ifmapj.messages.SearchResult;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class IFMAPMessagingFacade
implements Observer {
    private static IFMAPMessagingFacade sInstance = new IFMAPMessagingFacade();
    public String mapServerIP;
    public PollingClientList pollingClientList = new PollingClientList();
    public final SOAPMessageSender sender = SOAPMessageSender.getInstance();
    private int mSubscribeIndex;
    private IFMAPMessagePollingThread mPoller;
    private boolean mIsARCPollingThreadActive = false;

    private IFMAPMessagingFacade() {
        this.pollingClientList = new PollingClientList();
        this.initSRC();
        if (GeneralConfig.APPLICATION_ARCPOLLING_ENABLED) {
            this.initARC();
        } else {
            IfMapClient.LOGGER.config("arc-polling is deactivated in configuration...not initializing arc-channel");
        }
        this.mSubscribeIndex = 0;
    }

    public static synchronized IFMAPMessagingFacade getInstance() {
        return sInstance;
    }

    public void init(String serverIP) {
        this.mapServerIP = serverIP;
        this.activateSOAPMessagePollingThread();
    }

    private void initSRC() {
        IfMapClient.LOGGER.info("initializing src-channel...");
        try {
            this.sender.prepareSSRC();
        }
        catch (InitializationException e) {
            e.printStackTrace();
            IfMapClient.exit("could not initialize messaging facade...preparation of src-channel failed!");
        }
    }

    private void initARC() {
        if (this.sender != null) {
            ARC arcChannel = this.sender.getARC();
            if (arcChannel != null) {
                IfMapClient.LOGGER.info("initializing arc-channel...");
                this.mPoller = new IFMAPMessagePollingThread(arcChannel);
                this.mPoller.sleepTime = 20;
                this.mPoller.addObserver(this);
            } else {
                IfMapClient.exit("could not initialize messaging facade...preparation of arc-channel failed!");
            }
        }
    }

    public String getIFMAPPublisherId() {
        return this.sender.getIfMapPublisherId();
    }

    public void sendNewSessionRequest() {
        try {
            IfMapClient.LOGGER.info("sending out new-session request over src...");
            this.sender.newSession();
        }
        catch (IfmapErrorResult e) {
            IfMapClient.exit("ifmap-error-result while sending new-session request: " + (Object)((Object)e));
        }
        catch (IfmapException e) {
            IfMapClient.exit("ifmap-exception while sending new-session request: " + (Object)((Object)e));
        }
    }

    public void sendPurgePublishRequest() {
        try {
            IfMapClient.LOGGER.info("sending out purge-publish request over src...");
            this.sender.purgePublisher();
        }
        catch (IfmapErrorResult e) {
            IfMapClient.exit("ifmap-error-result while sending purge-publish request: " + (Object)((Object)e));
        }
        catch (IfmapException e) {
            IfMapClient.exit("ifmap-exception while sending purge-publish request: " + (Object)((Object)e));
        }
    }

    public void sendEndSessionRequest() {
        try {
            IfMapClient.LOGGER.info("sending out end-session request over src...");
            this.sender.endSession();
        }
        catch (IfmapErrorResult e) {
            IfMapClient.exit("ifmap-error-result while sending end-session request: " + (Object)((Object)e));
        }
        catch (IfmapException e) {
            IfMapClient.exit("ifmap-exception while sending end-session request: " + (Object)((Object)e));
        }
    }

    public void sendPublishEventRequest(MappingResult[] resultList) {
        if (GeneralConfig.APPLICATION_SNORT_MODE.equalsIgnoreCase("esukom")) {
            if (GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME.equals("de.esukom.decoit.ifmapclient.mappingfactory.SnortFileEventMappingFactory") || GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME.equals("de.esukom.decoit.ifmapclient.mappingfactory.SnortBarnyardFileEventMappingFactory") || GeneralConfig.APPLICATION_MAPPINGCONFIG_CLASSNAME.equals("de.esukom.decoit.ifmapclient.mappingfactory.SnortSqlEventMappingFactory")) {
                this.sender.publishEsukomSpecificSnortEventUpdate(resultList);
            }
        } else {
            this.sender.publishEventUpdate(resultList);
        }
    }

    public void activateSOAPMessagePollingThread() {
        if (this.mPoller != null) {
            if (!this.mIsARCPollingThreadActive) {
                if (this.pollingClientList.getAllSubscribedEntrys() != null && this.pollingClientList.getAllSubscribedEntrys().size() > 0) {
                    IfMapClient.LOGGER.config("activating arc-polling-thread...");
                    this.mPoller.running = true;
                    this.mPoller.pausing = false;
                    new Thread(this.mPoller).start();
                    this.mIsARCPollingThreadActive = true;
                } else {
                    IfMapClient.LOGGER.info("not activiating arc-polling-thread because there are no subscribtions found");
                }
            } else {
                IfMapClient.LOGGER.info("not activiating arc-polling-thread because it is already set active");
            }
        }
    }

    public void activateSOAPMessagePollingThreadForAlertEvents() {
        if (this.mPoller != null) {
            if (!this.mIsARCPollingThreadActive) {
                IfMapClient.LOGGER.config("activating arc-polling-thread...");
                this.mPoller.running = true;
                this.mPoller.pausing = false;
                new Thread(this.mPoller).start();
                this.mIsARCPollingThreadActive = true;
            } else {
                IfMapClient.LOGGER.info("not activiating arc-polling-thread because it is already set active");
            }
        }
    }

    public void updateSubscribtions() {
        IfMapClient.LOGGER.info("updating subscriptions...");
        if (this.pollingClientList != null && this.pollingClientList.getClientList().size() > 0) {
            int i = 0;
            while (i < this.pollingClientList.getClientList().size()) {
                if (!this.pollingClientList.getClientList().get(i).isSubscribed()) {
                    if (this.sender != null) {
                        IfMapClient.LOGGER.info("subscribing client: " + this.pollingClientList.getClientList().get(i).getIPAddress() + ", current subscribe-index is: " + this.mSubscribeIndex);
                        this.sender.publishSubscription(this.pollingClientList.getClientList().get(i).getIPAddress(), this.mSubscribeIndex);
                        this.pollingClientList.getClientList().get(i).setSubscribed(true);
                        this.pollingClientList.getClientList().get(i).setSubscriptionName(this.mSubscribeIndex);
                        ++this.mSubscribeIndex;
                        IfMapClient.LOGGER.info("subscription published...trying to activate ARC-Poller");
                        this.activateSOAPMessagePollingThread();
                    } else {
                        IfMapClient.exit("error while initializing Subscription: SOAPMessageSender cannot be null!");
                    }
                }
                ++i;
            }
        } else {
            IfMapClient.LOGGER.info("no entries found in subscription-list...no subscriptions to be published");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void checkEntriesForAllowance(MappingResult[] resultList) {
        block8: {
            checkClient = false;
            if (resultList == null) break block8;
            i = 0;
            while (i < resultList.length) {
                block9: {
                    currentEventResult = (EventMappingResult)resultList[i];
                    currentIp = currentEventResult.getIp();
                    newEntry = new PollingClientListEntry(currentIp);
                    if (!this.pollingClientList.insertEntryIfIPNotExists(newEntry)) break block9;
                    IfMapClient.LOGGER.info("new client has been added to client list: " + currentIp);
                    checkClient = true;
                    ** GOTO lbl18
                }
                IfMapClient.LOGGER.info("client is already in client-list...checking current state now");
                if (IFMAPMessagingFacade.getInstance().pollingClientList.isClientBlockedOrAllowed(currentIp)) {
                    IfMapClient.LOGGER.info("client has been already blocked or allowed: " + currentIp + "...not checking allowance");
                } else {
                    checkClient = true;
lbl18:
                    // 2 sources

                    if (checkClient && this.sender != null) {
                        IfMapClient.LOGGER.info("allowance-checking for client: " + currentIp);
                        if (this.executeSearchRequestAndCheckAllowance(currentIp)) {
                            ipTablesRulesExecutor = RulesExecutor.getInstance();
                            IfMapClient.LOGGER.info("executing allowance rule for input table for client " + currentIp);
                            ipTablesRulesExecutor.executePredefinedRule((byte)2, new String[]{currentIp});
                            if (GeneralConfig.APPLICATION_IPTABLES_GATEWAYMODE) {
                                IfMapClient.LOGGER.info("executing allowance rule for forward table for client " + currentIp);
                                ipTablesRulesExecutor.executePredefinedRule((byte)3, new String[]{currentIp});
                            }
                            IfMapClient.LOGGER.info("client has been allowed: " + currentIp + "...setting allowed-state for entry");
                            this.pollingClientList.getEntryByIpString(currentIp).setAllowed(true);
                        } else {
                            IfMapClient.LOGGER.info("allowance check: " + currentIp + " has not been allowed");
                        }
                    } else {
                        IfMapClient.exit("error while performing allowance-check: SOAPMessageSender cannot be null!");
                    }
                }
                ++i;
            }
        }
    }

    public boolean executeSearchRequestAndCheckAllowance(String ip) {
        if (IPTablesFacade.getInstance().mSkipAllowClientCheck) {
            IfMapClient.LOGGER.info("skip allowance check is set, client with " + ip + " has been allowed!");
            return true;
        }
        IfMapClient.LOGGER.info("------------------------------------------------------------------");
        IfMapClient.LOGGER.info("executeSearchRequestAndCheckAllowance : String " + ip);
        IfMapClient.LOGGER.info("------------------------------------------------------------------");
        SearchResult myResult = this.sender.publishSearchRequest(ip);
        IfMapClient.LOGGER.info("incoming search-result from search request for ip " + ip);
        if (myResult != null) {
            List resultItems = myResult.getResultItems();
            boolean isOk = false;
            int i = 0;
            while (i < resultItems.size()) {
                if (((ResultItem)resultItems.get(i)).getIdentifier1() != null) {
                    IfMapClient.LOGGER.fine("entry[" + i + "] - Identifier 1 Name:" + ((ResultItem)resultItems.get(i)).getIdentifier1().toString());
                }
                if (((ResultItem)resultItems.get(i)).getIdentifier2() != null) {
                    IfMapClient.LOGGER.fine("entry[" + i + "] - Identifier 2 Name:" + ((ResultItem)resultItems.get(i)).getIdentifier2().toString());
                }
                if (((ResultItem)resultItems.get(i)).getMetadata() != null) {
                    List mresult = ((ResultItem)resultItems.get(i)).getMetadata();
                    for (Document currentDoc : mresult) {
                        NodeList list = currentDoc.getChildNodes();
                        isOk = IPTablesFacade.getInstance().checkPollSearchMetadataForAllowance(list, (byte)5);
                        if (!isOk) continue;
                        IfMapClient.LOGGER.info("client with " + ip + " has been allowed!");
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public void subscribeToAlertEvents() {
        IfMapClient.LOGGER.info("subscribing to alert-events...");
        this.sender.publishAlertSubscribtion();
        this.activateSOAPMessagePollingThreadForAlertEvents();
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        IfMapClient.LOGGER.info("ifmap-messaging-facade detected callback from arc-poller...");
        if (o != null) {
            PollResult tmpResult = (PollResult)arg;
            this.checkPollResult(tmpResult);
        } else {
            IfMapClient.LOGGER.info("result from " + GeneralConfig.APPLICATION_POLLINGCONFIG_CLASSNAME + " is null, nothing to do!");
        }
        this.activateSOAPMessagePollingThread();
    }

    public void checkPollResult(PollResult result) {
        SearchResult search;
        IfMapClient.LOGGER.info("checking incoming poll result...");
        if (result != null && result.getSearchResults().size() > 0 && (search = (SearchResult)result.getSearchResults().iterator().next()) != null && GeneralConfig.APPLICATION_IPTABLES_MODE.equalsIgnoreCase("default")) {
            IPTablesFacade.getInstance().checkPollResultForIPTablesEvent(search.getResultItems(), (byte)5);
        }
        if (result != null && result.getUpdateResults().size() > 0) {
            Collection update = result.getUpdateResults();
            for (SearchResult sr : update) {
                if (GeneralConfig.APPLICATION_IPTABLES_MODE.equalsIgnoreCase("esukom")) {
                    IPTablesFacade.getInstance().checkPollResultForIPTablesAlert(sr.getResultItems(), (byte)6);
                    continue;
                }
                IPTablesFacade.getInstance().checkPollResultForIPTablesEvent(sr.getResultItems(), (byte)6);
            }
        }
    }
}

