/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingFactory;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import de.fhhannover.inform.trust.ifmapj.metadata.Significance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class NagiosEventMappingFactory
extends MappingFactory {
    private EventType mEventtypeDefault;
    private String mMagnitudeDefault;
    private String mConfidenceDefault;
    private Significance mSignificanceDefault;
    private final String mTimestampKey = "timestamp";
    private final String mAddressKey = "address";
    private final String mEventsourceKey = "source";
    private final String mEventstateKey = "state";

    public NagiosEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> data) {
        this.initProperties(props);
        boolean successfull = true;
        EventMappingResult event = new EventMappingResult();
        int i = 0;
        while (i < data.size()) {
            if (data.get(i).get("timestamp") == null) {
                IfMapClient.LOGGER.warning("mapping of nagios-event failed - cannot find value for event.discovered_time");
                successfull = false;
                break;
            }
            event.setDiscoveredTime(this.rearrangeDate(data.get(i).get("timestamp")));
            if (data.get(i).get("address") == null) {
                IfMapClient.LOGGER.warning("mapping of nagios-event failed - cannot find value for event.ip");
                successfull = false;
                break;
            }
            event.setIp(data.get(i).get("address"));
            if (data.get(i).get("source") == null || data.get(i).get("state") == null) {
                IfMapClient.LOGGER.warning("mapping of nagios-event failed - cannot find values for event.name");
                successfull = false;
                break;
            }
            event.setName(this.getEventnameValue(data.get(i).get("source"), data.get(i).get("state")));
            if (successfull) {
                event.setIpType("IPv4");
                event.setDiscovererId(SOAPMessageSender.getInstance().getIfMapPublisherId());
                event.setSignificance(this.mSignificanceDefault);
                event.setEventMessageType(this.mEventtypeDefault);
                event.setConfidence(this.mConfidenceDefault);
                event.setMagnitude(this.mMagnitudeDefault);
            }
            ++i;
        }
        if (successfull) {
            this.mapResult.add(event);
            IfMapClient.LOGGER.fine("mapped nagios event has been added to result list: " + event.showOnConsole());
        } else {
            this.mapResult = null;
        }
    }

    @Override
    public void initProperties(Properties props) {
        boolean criticalErrorOcured = false;
        this.mEventtypeDefault = EventType.behavioralChange;
        String eventTypeFromConfig = Toolbox.getStringProperty("nagios.eventmapping.eventtype", props, false);
        if (this.mEventtypeDefault == null) {
            criticalErrorOcured = true;
        }
        if (eventTypeFromConfig == "botnet-infection") {
            this.mEventtypeDefault = EventType.botnetInfection;
        } else if (eventTypeFromConfig == "cve") {
            this.mEventtypeDefault = EventType.cve;
        } else if (eventTypeFromConfig == "excessive-flows") {
            this.mEventtypeDefault = EventType.excessiveFlows;
        } else if (eventTypeFromConfig == "other") {
            this.mEventtypeDefault = EventType.other;
        } else if (eventTypeFromConfig == "p2p") {
            this.mEventtypeDefault = EventType.p2p;
        } else if (eventTypeFromConfig == "policy-violation") {
            this.mEventtypeDefault = EventType.policyViolation;
        } else if (eventTypeFromConfig == "worm-infection") {
            this.mEventtypeDefault = EventType.wormInfection;
        } else {
            IfMapClient.LOGGER.config("could not load default event-type value from nagios mapping config...using default (behavioral-change)");
        }
        this.mMagnitudeDefault = Toolbox.getStringProperty("nagios.eventmapping.magnitude", props, false);
        if (this.mMagnitudeDefault == null) {
            criticalErrorOcured = true;
        }
        this.mConfidenceDefault = Toolbox.getStringProperty("nagios.eventmapping.confidence", props, false);
        if (this.mConfidenceDefault == null) {
            criticalErrorOcured = true;
        }
        this.mSignificanceDefault = Significance.informational;
        String significanceFromConfig = Toolbox.getStringProperty("nagios.eventmapping.significance", props, false);
        if (significanceFromConfig == "important") {
            this.mSignificanceDefault = Significance.important;
        } else if (significanceFromConfig == "critical") {
            this.mSignificanceDefault = Significance.critical;
        } else {
            IfMapClient.LOGGER.config("could not load default significance value from nagios mapping config...using default (informational)");
        }
        if (criticalErrorOcured) {
            IfMapClient.exit("error while initializing NagiosEventMappingFactory");
        }
    }

    private String rearrangeDate(String currentDate) {
        String[] timestamp = currentDate.split("-");
        String[] date = timestamp[0].split("/");
        return String.valueOf(date[0]) + "-" + date[1] + "-" + date[2] + "T" + timestamp[1] + "Z";
    }

    public String getEventnameValue(String name, String state) {
        if (name.startsWith("service")) {
            return "Detected Service State: " + state;
        }
        if (name.startsWith("host")) {
            return "Detected Host State: " + state;
        }
        return "Undefined Event Name";
    }
}

