/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.identifier;

import de.fhhannover.inform.trust.ifmapj.exception.MarshalException;
import de.fhhannover.inform.trust.ifmapj.exception.UnmarshalException;
import de.fhhannover.inform.trust.ifmapj.identifier.AccessRequest;
import de.fhhannover.inform.trust.ifmapj.identifier.AccessRequestHandler;
import de.fhhannover.inform.trust.ifmapj.identifier.Device;
import de.fhhannover.inform.trust.ifmapj.identifier.DeviceHandler;
import de.fhhannover.inform.trust.ifmapj.identifier.Identifier;
import de.fhhannover.inform.trust.ifmapj.identifier.IdentifierFactory;
import de.fhhannover.inform.trust.ifmapj.identifier.IdentifierFactoryImpl;
import de.fhhannover.inform.trust.ifmapj.identifier.IdentifierHandler;
import de.fhhannover.inform.trust.ifmapj.identifier.IdentifierWithAd;
import de.fhhannover.inform.trust.ifmapj.identifier.Identity;
import de.fhhannover.inform.trust.ifmapj.identifier.IdentityHandler;
import de.fhhannover.inform.trust.ifmapj.identifier.IdentityType;
import de.fhhannover.inform.trust.ifmapj.identifier.IpAddress;
import de.fhhannover.inform.trust.ifmapj.identifier.IpAddressHandler;
import de.fhhannover.inform.trust.ifmapj.identifier.IpAddressType;
import de.fhhannover.inform.trust.ifmapj.identifier.MacAddress;
import de.fhhannover.inform.trust.ifmapj.identifier.MacAddressHandler;
import de.fhhannover.inform.trust.ifmapj.log.IfmapJLog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

public class Identifiers {
    private static IdentifierFactory sIdentifierFactoryInstance;
    private static Map<Class<? extends Identifier>, IdentifierHandler<? extends Identifier>> sIdentifierHandlers;

    private Identifiers() {
    }

    public static IdentifierFactory getIdentifierFactory() {
        if (sIdentifierFactoryInstance == null) {
            sIdentifierFactoryInstance = new IdentifierFactoryImpl();
        }
        return sIdentifierFactoryInstance;
    }

    public static void registerIdentifierHandler(IdentifierHandler<? extends Identifier> ih) {
        if (ih == null) {
            throw new NullPointerException("ih is null");
        }
        if (ih.handles() == null) {
            throw new NullPointerException("ih.handles() returns null");
        }
        if (sIdentifierHandlers == null) {
            Identifiers.initializeDefaultHandlers();
        }
        if (sIdentifierHandlers.containsKey(ih.handles())) {
            throw new RuntimeException("IdentifierHandler already registered for " + ih.handles());
        }
        sIdentifierHandlers.put(ih.handles(), ih);
    }

    public static IdentifierHandler<? extends Identifier> getHandlerFor(Identifier i) {
        if (sIdentifierHandlers == null) {
            Identifiers.initializeDefaultHandlers();
        }
        for (Map.Entry<Class<? extends Identifier>, IdentifierHandler<? extends Identifier>> entry : sIdentifierHandlers.entrySet()) {
            if (!entry.getKey().isInstance(i)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static void initializeDefaultHandlers() {
        sIdentifierHandlers = new HashMap<Class<? extends Identifier>, IdentifierHandler<? extends Identifier>>();
        Identifiers.registerIdentifierHandler(new AccessRequestHandler());
        Identifiers.registerIdentifierHandler(new DeviceHandler());
        Identifiers.registerIdentifierHandler(new IdentityHandler());
        Identifiers.registerIdentifierHandler(new IpAddressHandler());
        Identifiers.registerIdentifierHandler(new MacAddressHandler());
    }

    public static final Identifier tryFromElement(Element el) throws UnmarshalException {
        IdentifierHandler<? extends Identifier> handler;
        Identifier ret = null;
        if (sIdentifierHandlers == null) {
            Identifiers.initializeDefaultHandlers();
        }
        Iterator<IdentifierHandler<? extends Identifier>> i$ = sIdentifierHandlers.values().iterator();
        while (i$.hasNext() && (ret = (handler = i$.next()).fromElement(el)) == null) {
        }
        return ret;
    }

    public static final Identifier fromElement(Element el) throws UnmarshalException {
        Identifier ret = Identifiers.tryFromElement(el);
        if (ret == null) {
            throw new UnmarshalException("No IdentifierHandler could parse element with name " + el.getLocalName() + " in namespace " + el.getNamespaceURI());
        }
        return ret;
    }

    public static final Element tryToElement(Identifier i, Document doc) {
        IdentifierHandler<? extends Identifier> ih = null;
        Element elId = null;
        ih = Identifiers.getHandlerFor(i);
        if (ih == null) {
            IfmapJLog.warn("No IdentifierHandler for " + i.getClass());
            return null;
        }
        try {
            elId = ih.toElement(i, doc);
        }
        catch (MarshalException e) {
            IfmapJLog.warn("IdentifierHandler for " + i.getClass() + " threw exception:" + e.getMessage());
            return null;
        }
        if (elId == null) {
            IfmapJLog.warn("IdentifierHandler for " + i.getClass() + " returned null!");
        }
        return elId;
    }

    public static final Element toElement(Identifier i, Document doc) throws MarshalException {
        Element ret = Identifiers.tryToElement(i, doc);
        if (ret == null) {
            throw new MarshalException("No IdentifierHandler or error during conversion of Identifier to Element");
        }
        return ret;
    }

    public static AccessRequest createAr(String name) {
        return Identifiers.createAr(name, null);
    }

    public static AccessRequest createAr(String name, String admDom) {
        return new AccessRequest(name, admDom);
    }

    public static Device createDev(String name) {
        return new Device(name);
    }

    public static Identity createIdentity(IdentityType type, String name) {
        return Identifiers.createIdentity(type, name, null, null);
    }

    public static Identity createIdentity(IdentityType type, String name, String admDom) {
        return Identifiers.createIdentity(type, name, admDom, null);
    }

    public static Identity createOtherIdentity(String name, String admDom, String otherTypeDef) {
        return Identifiers.createIdentity(IdentityType.other, name, admDom, otherTypeDef);
    }

    public static Identity createIdentity(IdentityType type, String name, String admDom, String otherTypeDef) {
        return new Identity(type, name, admDom, otherTypeDef);
    }

    public static IpAddress createIp4(String value) {
        return Identifiers.createIp4(value, null);
    }

    public static IpAddress createIp4(String value, String admDom) {
        return Identifiers.createIp(IpAddressType.IPv4, value, admDom);
    }

    public static IpAddress createIp6(String value) {
        return Identifiers.createIp6(value, null);
    }

    public static IpAddress createIp6(String value, String admDom) {
        return Identifiers.createIp(IpAddressType.IPv6, value, admDom);
    }

    public static IpAddress createIp(IpAddressType type, String value, String admDom) {
        return new IpAddress(type, value, admDom);
    }

    public static MacAddress createMac(String value) {
        return Identifiers.createMac(value, null);
    }

    public static MacAddress createMac(String value, String admDom) {
        return new MacAddress(value, admDom);
    }

    public static class Helpers {
        private Helpers() {
        }

        public static String getAdministrativeDomain(Element el) {
            Attr node = el.getAttributeNode("administrative-domain");
            return node != null && node.getValue().length() > 0 ? node.getValue() : null;
        }

        public static void checkIdentifierType(Identifier i, IdentifierHandler<? extends Identifier> ih) throws MarshalException {
            Class<? extends Identifier> clazz = ih.handles();
            if (!clazz.isInstance(i)) {
                throw new MarshalException("Handler for identifier of type " + ih.handles() + " got identifier of type " + i.getClass());
            }
        }

        public static void addAdministrativeDomain(Element to, IdentifierWithAd i) {
            String adom = i.getAdministrativeDomain();
            if (adom != null && adom.length() > 0) {
                DomHelpers.addAttribute(to, "administrative-domain", adom);
            }
        }
    }
}

