/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.messages;

import de.fhhannover.inform.trust.ifmapj.exception.IfmapErrorResult;
import de.fhhannover.inform.trust.ifmapj.messages.PollResult;
import de.fhhannover.inform.trust.ifmapj.messages.SearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class PollResultImpl
implements PollResult {
    private final List<SearchResult> mResults;
    private final Collection<IfmapErrorResult> mErrorResults;

    PollResultImpl(List<SearchResult> results, Collection<IfmapErrorResult> eres) {
        if (results == null || eres == null) {
            throw new NullPointerException("result list is null");
        }
        this.mResults = new ArrayList<SearchResult>(results);
        this.mErrorResults = new ArrayList<IfmapErrorResult>(eres);
    }

    @Override
    public List<SearchResult> getResults() {
        return Collections.unmodifiableList(this.mResults);
    }

    @Override
    public Collection<SearchResult> getSearchResults() {
        return this.resultsOfType(SearchResult.Type.searchResult);
    }

    @Override
    public Collection<SearchResult> getUpdateResults() {
        return this.resultsOfType(SearchResult.Type.updateResult);
    }

    @Override
    public Collection<SearchResult> getDeleteResults() {
        return this.resultsOfType(SearchResult.Type.deleteResult);
    }

    @Override
    public Collection<SearchResult> getNotifyResults() {
        return this.resultsOfType(SearchResult.Type.notifyResult);
    }

    @Override
    public Collection<IfmapErrorResult> getErrorResults() {
        return Collections.unmodifiableCollection(this.mErrorResults);
    }

    private Collection<SearchResult> resultsOfType(SearchResult.Type type) {
        ArrayList<SearchResult> ret = new ArrayList<SearchResult>();
        for (SearchResult sr : this.mResults) {
            if (sr.getType() != type) continue;
            ret.add(sr);
        }
        return Collections.unmodifiableCollection(ret);
    }
}

