/* 
 * SnortBarnyardFilePollingThread.java        0.1.4 12/02/16
 *  
 * DEVELOPED BY DECOIT GMBH WITHIN THE ESUKOM-PROJECT:
 * http://www.decoit.de/
 * http://www.esukom.de/cms/front_content.php?idcat=10&lang=1
 * 
 * DERIVED FROM  THE DHCP-IFMAP-CLIENT-IMPLEMENTATION DEVELOPED BY 
 * FHH/TRUST WITHIN THE IRON-PROJECT:
 * http://trust.inform.fh-hannover.de/joomla/
 * 
 * Licensed to the Apache Software Foundation (ASF) under one 
 * or more contributor license agreements.  See the NOTICE file 
 * distributed with this work for additional information 
 * regarding copyright ownership.  The ASF licenses this file 
 * to you under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License.  You may obtain a copy of the License at 
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
 * KIND, either express or implied.  See the License for the 
 * specific language governing permissions and limitations 
 * under the License. 
 */

package de.esukom.decoit.ifmapclient.pollingthreads;

import de.esukom.decoit.ifmapclient.main.IfMapClient;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

/**
 * Thread for polling the Alertlog-File for new Snort-Events
 * 
 * @version 0.1.4
 * @author Dennis Dunekacke, Decoit GmbH
 */
public class SnortBarnyardFilePollingThread extends FilePollingThread {

    /**
     * constructor
     * 
     * @param path
     *            path of snort-log-file
     */
    public SnortBarnyardFilePollingThread(Properties pr) {
        // initialize properties
        initProperties(pr);
    }

    @Override
    protected ArrayList<HashMap<String, String>> readFile() {
        // number of read lines in current cycle, used to determine
        // current position inside file (in terms of already read lines )
        int currentCycleLineNumber = 0;

        BufferedReader input = null;
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        try {
            input = new BufferedReader(new FileReader(file), 1);

            // read lines
            String line = null;
            while ((line = input.readLine()) != null) {

                // check if entry should be added
                if (line.length() > 0
                        && (isFirstStart | currentCycleLineNumber > lastEntryLineNumber - 1)) {

                    // put current line in temporary event map
                    HashMap<String, String> tempEventData = new HashMap<String, String>();
                    tempEventData.put("0", line);

                    // add temporary event map to result-list
                    result.add(tempEventData);

                    isFirstStart = false;
                }

                // increase current read-cycle-counter
                currentCycleLineNumber++;
            }

            // set line to continue in next read-cycle
            lastEntryLineNumber += result.size();

        } catch (FileNotFoundException ex) {
            ex.printStackTrace();
            IfMapClient
                    .exit("error while opening snort-barnyard log-file...the file does not exists, please check your configuration");
        } catch (IOException ex) {
            ex.printStackTrace();
            IfMapClient.exit("I/O error while reading snort-barnyard log-file");
        } finally {
            try {
                input.close();
            } catch (IOException e) {
                e.printStackTrace();
                IfMapClient
                        .exit("error while closing input buffer after trying to read snort-barnyard log-file");
            }
        }

        return result;
    }
}